/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import org.opennms.dashboard.client.Alarm;
import org.opennms.dashboard.client.AlarmView;
import org.opennms.dashboard.client.Dashboard;
import org.opennms.dashboard.client.Dashlet;
import org.opennms.dashboard.client.DashletLoader;
import org.opennms.dashboard.client.SurveillanceServiceAsync;
import org.opennms.dashboard.client.SurveillanceSet;

public class AlarmDashlet
extends Dashlet {
    private AlarmView m_view = new AlarmView(this);
    private AlarmLoader m_loader = new AlarmLoader();

    AlarmDashlet(Dashboard dashboard) {
        super(dashboard, "Alarms");
        this.setLoader(this.m_loader);
        this.setView(this.m_view);
    }

    @Override
    public void setSurveillanceSet(SurveillanceSet set) {
        this.m_loader.load(set);
    }

    public void setSurveillanceService(SurveillanceServiceAsync svc) {
        this.m_loader.setSurveillanceService(svc);
    }

    class AlarmLoader
    extends DashletLoader
    implements AsyncCallback<Alarm[]> {
        private SurveillanceServiceAsync m_suveillanceService;

        AlarmLoader() {
        }

        public void load(SurveillanceSet surveillanceSet) {
            this.loading();
            this.m_suveillanceService.getAlarmsForSet(surveillanceSet, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDataLoaded(Alarm[] alarms) {
            try {
                AlarmDashlet.this.m_view.setAlarms(alarms);
            }
            finally {
                this.complete();
            }
        }

        public void setSurveillanceService(SurveillanceServiceAsync svc) {
            this.m_suveillanceService = svc;
        }

        public void onFailure(Throwable caught) {
            this.loadError(caught);
            AlarmDashlet.this.error(caught);
        }

        public void onSuccess(Alarm[] result) {
            this.onDataLoaded(result);
        }
    }
}

