/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.OutageDao;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.AggregateStatusDefinition;
import org.opennms.netmgt.model.AggregateStatusView;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.web.svclayer.AggregateStatus;
import org.opennms.web.svclayer.SiteStatusViewService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:META-INF/opennms/applicationContext-dao.xml", "classpath:META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:META-INF/opennms/applicationContext-databasePopulator.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-insertData-enabled.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class DefaultSiteStatusServiceIntegrationTest
implements InitializingBean {
    @Autowired
    private SiteStatusViewService m_aggregateService;
    @Autowired
    private DatabasePopulator m_databasePopulator;
    @Autowired
    private OutageDao m_outageDao;
    @Autowired
    private EventDao m_eventDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private CategoryDao m_categoryDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Test
    @Transactional
    public void testCreateAggregateStatusView() {
        this.m_databasePopulator.populateDatabase();
        AggregateStatusView view = this.m_aggregateService.createAggregateStatusView(null);
        Assert.assertNotNull((Object)view);
        Assert.assertFalse((boolean)view.getStatusDefinitions().isEmpty());
    }

    @Test
    @Transactional
    public void testCreateAggregateStatusUsingNodeId() {
        this.m_databasePopulator.populateDatabase();
        Collection aggrStati = this.m_aggregateService.createAggregateStatusesUsingNodeId(this.m_databasePopulator.getNode1().getId().intValue(), "default");
        Assert.assertNotNull((Object)aggrStati);
    }

    private void createOutageForNodeInCategory(String categoryName) {
        OnmsCategory category = this.m_categoryDao.findByName(categoryName);
        List nodes = this.m_nodeDao.findByCategory(category);
        Assert.assertNotNull((Object)nodes);
        Assert.assertFalse((boolean)nodes.isEmpty());
        OnmsNode node = (OnmsNode)nodes.iterator().next();
        node.visit((EntityVisitor)new AbstractEntityVisitor(){

            public void visitMonitoredService(OnmsMonitoredService monSvc) {
                DefaultSiteStatusServiceIntegrationTest.this.createOutageForService(monSvc);
            }
        });
    }

    protected void createOutageForService(OnmsMonitoredService monSvc) {
        OnmsEvent outageEvent = new OnmsEvent();
        outageEvent.setEventUei("TEST_UEI");
        outageEvent.setDistPoller(monSvc.getIpInterface().getNode().getDistPoller());
        outageEvent.setEventTime(new Date());
        outageEvent.setEventSource("Me");
        outageEvent.setEventCreateTime(new Date());
        outageEvent.setEventSeverity(Integer.valueOf(0));
        outageEvent.setEventLog("L");
        outageEvent.setEventDisplay("D");
        this.m_eventDao.save((Object)outageEvent);
        this.m_eventDao.flush();
        OnmsOutage outage = new OnmsOutage(new Date(), outageEvent, monSvc);
        this.m_outageDao.save((Object)outage);
        this.m_outageDao.flush();
    }

    @Test
    @Transactional
    public void testCreateAggregateStatusUsingBuilding() {
        this.m_databasePopulator.populateDatabase();
        this.createOutageForNodeInCategory("Routers");
        this.createOutageForNodeInCategory("Servers");
        ArrayList<AggregateStatusDefinition> defs = new ArrayList<AggregateStatusDefinition>();
        AggregateStatusDefinition definition = new AggregateStatusDefinition("Routers", new HashSet<OnmsCategory>(Arrays.asList(new OnmsCategory("Routers"))));
        defs.add(definition);
        definition = new AggregateStatusDefinition("Switches", new HashSet<OnmsCategory>(Arrays.asList(new OnmsCategory("Switches"))));
        defs.add(definition);
        definition = new AggregateStatusDefinition("Servers", new HashSet<OnmsCategory>(Arrays.asList(new OnmsCategory("Servers"))));
        defs.add(definition);
        AggregateStatusView view = new AggregateStatusView();
        view.setName("building");
        view.setColumnName("building");
        view.setColumnValue("HQ");
        view.setStatusDefinitions(new LinkedHashSet(defs));
        ArrayList aggrStati = new ArrayList(this.m_aggregateService.createAggregateStatuses(view));
        AggregateStatus status = (AggregateStatus)aggrStati.get(0);
        Assert.assertEquals((Object)status.getStatus(), (Object)"Critical");
        status = (AggregateStatus)aggrStati.get(1);
        Assert.assertEquals((Object)status.getStatus(), (Object)"Normal");
        status = (AggregateStatus)aggrStati.get(2);
        Assert.assertEquals((Object)status.getStatus(), (Object)"Critical");
    }
}

