/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.web.rest.AbstractSpringJerseyRestTestCase;

public class KscRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    private File m_configFile = new File("target/test-classes/ksc-performance-reports.xml");

    @Override
    protected void beforeServletStart() throws Exception {
        KSC_PerformanceReportFactory.setConfigFile((File)this.m_configFile);
    }

    @Override
    protected void afterServletStart() throws Exception {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
    }

    @Test
    public void testReadOnly() throws Exception {
        String xml = this.sendRequest(GET, "/ksc", 200);
        Assert.assertTrue((boolean)xml.contains("Test 2"));
        xml = this.sendRequest(GET, "/ksc/0", 200);
        Assert.assertTrue((boolean)xml.contains("label=\"Test\""));
        this.sendRequest(GET, "/ksc/3", 404);
    }

    @Test
    public void testAddGraph() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("title", "foo");
        params.put("reportName", "bar");
        params.put("resourceId", "baz");
        this.sendRequest(PUT, "/ksc/0", params, 200);
        String xml = this.slurp(this.m_configFile);
        Assert.assertTrue((boolean)xml.contains("title=\"foo\""));
    }

    private String slurp(File file) throws Exception {
        FileReader fileReader = new FileReader(file);
        BufferedReader reader = new BufferedReader(fileReader);
        StringBuilder sb = new StringBuilder();
        while (reader.ready()) {
            String line = reader.readLine();
            System.err.println(line);
            sb.append(line).append('\n');
        }
        return sb.toString();
    }
}

