/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import javax.servlet.ServletContext;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.web.rest.AbstractSpringJerseyRestTestCase;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DataLinkInterfaceRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    private DatabasePopulator m_databasePopulator;

    @Override
    protected void afterServletStart() {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.m_databasePopulator = (DatabasePopulator)context.getBean("databasePopulator", DatabasePopulator.class);
        this.m_databasePopulator.populateDatabase();
    }

    @Test
    public void testLinks() throws Exception {
        String xml = this.sendRequest(GET, "/links", 200);
        Assert.assertTrue((boolean)xml.contains("<links count=\"3\""));
    }

    @Test
    public void testLink() throws Exception {
        String xml = this.sendRequest(GET, "/links/64", 200);
        Assert.assertTrue((boolean)xml.contains("<link id=\"64\">"));
        xml = this.sendRequest(GET, "/links/65", 200);
        Assert.assertTrue((boolean)xml.contains("<link id=\"65\">"));
        xml = this.sendRequest(GET, "/links/66", 200);
        Assert.assertTrue((boolean)xml.contains("<link id=\"66\">"));
    }

    @Test
    public void testQueryWithNodeid() throws Exception {
        String xml = this.sendRequest(GET, "/links", DataLinkInterfaceRestServiceTest.parseParamData("node.id=2"), 200);
        Assert.assertTrue((boolean)xml.contains("<links count=\"1\""));
    }

    @Test
    public void testQueryWithIfIndex() throws Exception {
        String xml = this.sendRequest(GET, "/links", DataLinkInterfaceRestServiceTest.parseParamData("ifIndex=1"), 200);
        Assert.assertTrue((boolean)xml.contains("<links count=\"2\""));
    }

    @Test
    public void testQueryWithParentNodeid() throws Exception {
        String xml = this.sendRequest(GET, "/links", DataLinkInterfaceRestServiceTest.parseParamData("nodeParentId=2"), 200);
        Assert.assertTrue((boolean)xml.contains("<links count=\"0\""));
    }

    @Test
    public void testQueryWithParentIfindex() throws Exception {
        String xml = this.sendRequest(GET, "/links", DataLinkInterfaceRestServiceTest.parseParamData("parentIfIndex=1"), 200);
        Assert.assertTrue((boolean)xml.contains("<links count=\"3\""));
    }

    @Test
    public void testQueryWithStatus() throws Exception {
        String xml = this.sendRequest(GET, "/links", DataLinkInterfaceRestServiceTest.parseParamData("status=A"), 200);
        Assert.assertTrue((boolean)xml.contains("<links count=\"3\""));
    }
}

