/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.DistPollerDao;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.web.rest.MockUserPrincipal;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AlarmRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    private DatabasePopulator m_databasePopulator;

    @Override
    protected void afterServletStart() {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.m_databasePopulator = (DatabasePopulator)context.getBean("databasePopulator", DatabasePopulator.class);
        this.m_databasePopulator.populateDatabase();
    }

    @Test
    public void testAlarms() throws Exception {
        String xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData("orderBy=lastEventTime&order=desc&alarmAckUser=null&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms/1", AlarmRestServiceTest.parseParamData("orderBy=lastEventTime&order=desc&alarmAckUser=null&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        Assert.assertTrue((boolean)xml.contains("<nodeLabel>node1</nodeLabel>"));
    }

    @Test
    public void testAlarmQueryByNode() throws Exception {
        String xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData("nodeId=6&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("<alarms"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData("node.id=6&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("<alarms"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData("node.label=node1&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("node1"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData("ipInterface.ipAddress=192.168.1.2&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("node1"));
    }

    @Test
    public void testAlarmQueryBySeverityEquals() throws Exception {
        String xml = null;
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData("comparator=eq&severity=NORMAL&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData("comparator=eq&severity=MAJOR&limit=1"), 200);
        Assert.assertFalse((boolean)xml.contains("This is a test alarm"));
    }

    @Test
    public void testAlarmQueryBySeverityLessThan() throws Exception {
        String xml = null;
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData("comparator=le&severity=NORMAL&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData("comparator=lt&severity=NORMAL&limit=1"), 200);
        Assert.assertFalse((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData("comparator=lt&severity=WARNING&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
    }

    @Test
    public void testAlarmQueryBySeverityGreaterThan() throws Exception {
        String xml = null;
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData("comparator=ge&severity=NORMAL&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData("comparator=gt&severity=NORMAL&limit=1"), 200);
        Assert.assertFalse((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData("comparator=gt&severity=CLEARED&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
    }

    @Test
    public void testAlarmUpdates() throws Exception {
        this.createAlarm(OnmsSeverity.MAJOR);
        OnmsAlarm alarm = this.getLastAlarm();
        alarm.setAlarmAckTime(null);
        alarm.setAlarmAckUser(null);
        this.getAlarmDao().saveOrUpdate((Object)alarm);
        Integer alarmId = alarm.getId();
        this.sendPut("/alarms", "ack=true&alarmId=" + alarmId, 204);
        String xml = this.sendRequest(GET, "/alarms/" + alarmId, 200);
        Assert.assertTrue((boolean)xml.contains("ackUser>admin<"));
        this.sendPut("/alarms/" + alarmId, "clear=true", 204);
        xml = this.sendRequest(GET, "/alarms/" + alarmId, 200);
        Assert.assertTrue((boolean)xml.contains("severity=\"CLEARED\""));
        this.sendPut("/alarms/" + alarmId, "escalate=true", 204);
        xml = this.sendRequest(GET, "/alarms/" + alarmId, 200);
        Assert.assertTrue((boolean)xml.contains("severity=\"NORMAL\""));
        alarm = this.getLastAlarm();
        alarm.setSeverity(OnmsSeverity.MAJOR);
        alarm.setAlarmAckTime(null);
        alarm.setAlarmAckUser(null);
        this.getAlarmDao().saveOrUpdate((Object)alarm);
        MockUserPrincipal.setName("foo");
        IllegalArgumentException failure = null;
        try {
            this.sendPut("/alarms/" + alarmId, "ack=true&ackUser=bar", 204);
        }
        catch (IllegalArgumentException e) {
            failure = e;
        }
        Assert.assertNotNull((Object)failure);
    }

    private OnmsAlarm getLastAlarm() {
        TreeSet<OnmsAlarm> alarms = new TreeSet<OnmsAlarm>(new Comparator<OnmsAlarm>(){

            @Override
            public int compare(OnmsAlarm a, OnmsAlarm b) {
                return a.getId().compareTo(b.getId());
            }
        });
        alarms.addAll(this.getAlarmDao().findAll());
        return (OnmsAlarm)alarms.last();
    }

    @Test
    public void testComplexQuery() throws Exception {
        String xml = null;
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.createAlarm(OnmsSeverity.CRITICAL);
        for (OnmsAlarm alarm : this.getAlarmDao().findAll()) {
            System.err.println("alarm = " + alarm);
        }
        parameters.put("offset", "00");
        parameters.put("limit", "10");
        parameters.put("orderBy", "lastEventTime");
        parameters.put("order", "desc");
        parameters.put("query", "lastEventTime > '2011-08-19T11:11:11.000-07:00' AND severity = 3");
        xml = this.sendRequest(GET, "/alarms", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("<alarm severity=\"NORMAL\" id=\"1\""));
        Assert.assertFalse((boolean)xml.contains("<alarm severity=\"CRITICAL\" id=\"2\""));
        parameters.put("query", "lastEventTime > '2011-08-19T11:11:11.000-07:00' AND severity >= 3");
        xml = this.sendRequest(GET, "/alarms", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("<alarm severity=\"NORMAL\" id=\"1\""));
        Assert.assertTrue((boolean)xml.contains("<alarm severity=\"CRITICAL\" id=\"2\""));
        parameters.put("query", "lastEventTime > '2011-08-19T11:11:11.000-07:00' AND severity >= NORMAL");
        xml = this.sendRequest(GET, "/alarms", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("<alarm severity=\"NORMAL\" id=\"1\""));
        Assert.assertTrue((boolean)xml.contains("<alarm severity=\"CRITICAL\" id=\"2\""));
        parameters.put("query", "lastEventTime > '2011-08-19T11:11:11.000-07:00' AND severity < NORMAL");
        xml = this.sendRequest(GET, "/alarms", parameters, 200);
        Assert.assertFalse((boolean)xml.contains("<alarm severity=\"NORMAL\" id=\"1\""));
        Assert.assertFalse((boolean)xml.contains("<alarm severity=\"CRITICAL\" id=\"2\""));
        Assert.assertTrue((boolean)xml.contains("count=\"0\""));
        parameters.put("query", "lastEventTime > '2011-08-19T11:11:11.000-07:00' AND severity > MAJOR AND alarmAckUser = 'admin'");
        xml = this.sendRequest(GET, "/alarms", parameters, 200);
        Assert.assertFalse((boolean)xml.contains("<alarm severity=\"NORMAL\" id=\"1\""));
        Assert.assertTrue((boolean)xml.contains("<alarm severity=\"CRITICAL\" id=\"2\""));
        parameters.put("query", "lastEventTime > '2011-08-19T11:11:11.000-07:00' AND severity > MAJOR AND alarmAckUser IS NULL");
        xml = this.sendRequest(GET, "/alarms", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("count=\"0\""));
        parameters.put("query", "lastEventTime > '2011-08-19T11:11:11.000-07:00' AND severity < MAJOR AND alarmAckUser IS NULL");
        xml = this.sendRequest(GET, "/alarms", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("<alarm severity=\"NORMAL\" id=\"1\""));
        Assert.assertFalse((boolean)xml.contains("<alarm severity=\"CRITICAL\" id=\"2\""));
    }

    private void createAlarm(OnmsSeverity severity) {
        OnmsEvent event = (OnmsEvent)this.getEventDao().findAll().get(0);
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setDistPoller((OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost")));
        alarm.setUei(event.getEventUei());
        alarm.setAlarmType(Integer.valueOf(1));
        alarm.setNode(this.m_databasePopulator.getNode1());
        alarm.setDescription("This is a test alarm");
        alarm.setLogMsg("this is a test alarm log message");
        alarm.setCounter(Integer.valueOf(1));
        alarm.setIpAddr(InetAddressUtils.getInetAddress((String)"192.168.1.1"));
        alarm.setSeverity(severity);
        alarm.setFirstEventTime(event.getEventTime());
        alarm.setLastEvent(event);
        alarm.setAlarmAckTime(new Date());
        alarm.setAlarmAckUser("admin");
        this.getAlarmDao().save((Object)alarm);
        this.getAlarmDao().flush();
    }

    private EventDao getEventDao() {
        return this.m_databasePopulator.getEventDao();
    }

    private AlarmDao getAlarmDao() {
        return this.m_databasePopulator.getAlarmDao();
    }

    private DistPollerDao getDistPollerDao() {
        return this.m_databasePopulator.getDistPollerDao();
    }
}

