/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.model.outage.OutageSummary;
import org.opennms.web.filter.Filter;
import org.opennms.web.outage.Outage;
import org.opennms.web.outage.WebOutageRepository;
import org.opennms.web.outage.filter.OutageCriteria;
import org.opennms.web.outage.filter.OutageIdFilter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/jdbcWebRepositoryTestContext.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class JdbcWebOutageRepositoryTest
implements InitializingBean {
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    WebOutageRepository m_outageRepo;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_dbPopulator.populateDatabase();
    }

    @Test
    @JUnitTemporaryDatabase
    public void testCountMatchingOutages() {
        OutageCriteria criteria = new OutageCriteria(new Filter[]{new OutageIdFilter(1)});
        int outages = this.m_outageRepo.countMatchingOutages(criteria);
        Assert.assertEquals((long)1L, (long)outages);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetOutage() {
        Outage[] outages = this.m_outageRepo.getMatchingOutages(new OutageCriteria(new Filter[]{new OutageIdFilter(1)}));
        Assert.assertNotNull((Object)outages);
        Assert.assertEquals((long)1L, (long)outages.length);
        Outage outage = this.m_outageRepo.getOutage(1);
        Assert.assertNotNull((Object)outage);
    }

    @Test
    @Transactional
    public void testGetOutages() {
        Outage[] outages = this.m_outageRepo.getMatchingOutages(new OutageCriteria(new Filter[0]));
        Assert.assertNotNull((Object)outages);
        Assert.assertEquals((long)2L, (long)outages.length);
        Assert.assertNotNull((Object)outages[0].getRegainedServiceTime());
        Assert.assertNull((Object)outages[1].getRegainedServiceTime());
    }

    @Test
    @Transactional
    public void testGetOutageSummaries() {
        OutageSummary[] summaries = this.m_outageRepo.getMatchingOutageSummaries(new OutageCriteria(new Filter[0]));
        Assert.assertEquals((String)"there should be 1 outage summary in the default (current) outage criteria match", (long)1L, (long)summaries.length);
    }
}

