/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.osgi;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.http.annotations.JUnitHttpServer;
import org.opennms.core.test.http.annotations.Webapp;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.mock.MockMonitoredService;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.PageSequenceMonitor;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:META-INF/opennms/emptyContext.xml"})
@JUnitHttpServer(port=10342)
public class FrameworkStartupContextListenerTest {
    PageSequenceMonitor m_monitor;
    Map<String, Object> m_params;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.m_monitor = new PageSequenceMonitor();
        this.m_monitor.initialize(Collections.emptyMap());
        this.m_params = new HashMap<String, Object>();
        this.m_params.put("timeout", "8000");
        this.m_params.put("retries", "1");
    }

    protected MonitoredService getHttpService(String hostname, InetAddress inetAddress) throws Exception {
        MockMonitoredService svc = new MockMonitoredService(1, hostname, inetAddress, "HTTP");
        this.m_monitor.initialize((MonitoredService)svc);
        return svc;
    }

    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/osgiTestWar")})
    public void testLogin() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page virtual-host=\"localhost\" path=\"/opennms/\" port=\"10342\" successMatch=\"Password\" />\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_check\" port=\"10342\" method=\"POST\" response-range=\"300-399\">\n    <parameter key=\"j_username\" value=\"demo\"/>\n    <parameter key=\"j_password\" value=\"demo\"/>\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_logout\" port=\"10342\" successMatch=\"Login with Username and Password\" />\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost", InetAddressUtils.addr((String)"127.0.0.1")), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }
}

