/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.notification;

import java.util.ArrayList;
import java.util.Date;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.web.filter.Filter;
import org.opennms.web.notification.AcknowledgeType;
import org.opennms.web.notification.Notification;
import org.opennms.web.notification.SortStyle;
import org.opennms.web.notification.WebNotificationRepository;
import org.opennms.web.notification.filter.AcknowledgedByFilter;
import org.opennms.web.notification.filter.NotificationCriteria;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/jdbcWebRepositoryTestContext.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class JdbcWebNotificationRepositoryTest
implements InitializingBean {
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    WebNotificationRepository m_notificationRepo;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_dbPopulator.populateDatabase();
    }

    @After
    public void tearDown() {
    }

    @Test
    @Transactional
    public void testNotificationCount() {
        ArrayList filterList = new ArrayList();
        Filter[] filters = filterList.toArray(new Filter[0]);
        AcknowledgeType ackType = AcknowledgeType.UNACKNOWLEDGED;
        int notificationCount = this.m_notificationRepo.countMatchingNotifications(new NotificationCriteria(ackType, filters));
        Assert.assertEquals((long)1L, (long)notificationCount);
    }

    @Test
    @Transactional
    public void testGetMatchingNotifications() {
        ArrayList filterList = new ArrayList();
        int limit = 10;
        int multiple = 0;
        AcknowledgeType ackType = AcknowledgeType.UNACKNOWLEDGED;
        SortStyle sortStyle = SortStyle.DEFAULT_SORT_STYLE;
        Filter[] filters = filterList.toArray(new Filter[0]);
        Notification[] notices = this.m_notificationRepo.getMatchingNotifications(new NotificationCriteria(filters, sortStyle, ackType, limit, limit * multiple));
        Assert.assertEquals((long)1L, (long)notices.length);
        Assert.assertEquals((Object)"This is a test notification", (Object)notices[0].getTextMessage());
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetNotification() {
        Notification notice = this.m_notificationRepo.getNotification(1);
        Assert.assertNotNull((Object)notice);
    }

    @Test
    @Transactional
    public void testAcknowledgeNotification() {
        this.m_notificationRepo.acknowledgeMatchingNotification("TestUser", new Date(), new NotificationCriteria(new Filter[0]));
        int notifCount = this.m_notificationRepo.countMatchingNotifications(new NotificationCriteria(new Filter[]{new AcknowledgedByFilter("TestUser")}));
        Assert.assertEquals((long)1L, (long)notifCount);
    }
}

