/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event.filter;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.alarm.filter.AlarmIdFilter;
import org.opennms.web.event.Event;
import org.opennms.web.event.WebEventRepository;
import org.opennms.web.event.filter.AcknowledgedByFilter;
import org.opennms.web.event.filter.AfterDateFilter;
import org.opennms.web.event.filter.BeforeDateFilter;
import org.opennms.web.event.filter.DescriptionSubstringFilter;
import org.opennms.web.event.filter.EventCriteria;
import org.opennms.web.event.filter.EventIdFilter;
import org.opennms.web.event.filter.EventIdListFilter;
import org.opennms.web.event.filter.ExactUEIFilter;
import org.opennms.web.event.filter.IPAddrLikeFilter;
import org.opennms.web.event.filter.IfIndexFilter;
import org.opennms.web.event.filter.InterfaceFilter;
import org.opennms.web.event.filter.LogMessageMatchesAnyFilter;
import org.opennms.web.event.filter.LogMessageSubstringFilter;
import org.opennms.web.event.filter.NegativeAcknowledgedByFilter;
import org.opennms.web.event.filter.NegativeExactUEIFilter;
import org.opennms.web.event.filter.NegativeInterfaceFilter;
import org.opennms.web.event.filter.NegativeNodeFilter;
import org.opennms.web.event.filter.NegativePartialUEIFilter;
import org.opennms.web.event.filter.NegativeServiceFilter;
import org.opennms.web.event.filter.NegativeSeverityFilter;
import org.opennms.web.event.filter.NodeFilter;
import org.opennms.web.event.filter.NodeNameLikeFilter;
import org.opennms.web.event.filter.PartialUEIFilter;
import org.opennms.web.event.filter.ServiceFilter;
import org.opennms.web.event.filter.SeverityFilter;
import org.opennms.web.filter.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/daoWebRepositoryTestContext.xml", "classpath:/jdbcWebRepositoryTestContext.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class WebEventRepositoryFilterTest
implements InitializingBean {
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    @Qualifier(value="dao")
    WebEventRepository m_daoEventRepo;
    @Autowired
    @Qualifier(value="jdbc")
    WebEventRepository m_jdbcEventRepo;
    @Autowired
    ApplicationContext m_appContext;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_dbPopulator.populateDatabase();
        OnmsEvent event = new OnmsEvent();
        event.setDistPoller(this.getDistPoller("localhost", "127.0.0.1"));
        event.setAlarm((OnmsAlarm)this.m_dbPopulator.getAlarmDao().get((Serializable)Integer.valueOf(1)));
        event.setNode(this.m_dbPopulator.getNode1());
        event.setEventUei("uei.opennms.org/test2");
        event.setEventTime(new Date());
        event.setEventSource("test");
        event.setEventCreateTime(new Date());
        event.setEventSeverity(Integer.valueOf(OnmsSeverity.CLEARED.getId()));
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        event.setIfIndex(Integer.valueOf(11));
        event.setIpAddr(InetAddressUtils.getInetAddress((String)"192.168.1.1"));
        event.setEventLogMsg("This is a test log message");
        event.setEventDescr("This is a test event");
        event.setServiceType((OnmsServiceType)this.m_dbPopulator.getServiceTypeDao().get((Serializable)Integer.valueOf(1)));
        this.m_dbPopulator.getEventDao().save((Object)event);
        this.m_dbPopulator.getEventDao().flush();
    }

    private OnmsDistPoller getDistPoller(String localhost, String localhostIp) {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.m_dbPopulator.getDistPollerDao().get((Serializable)((Object)localhost));
        if (distPoller == null) {
            distPoller = new OnmsDistPoller(localhost, localhostIp);
            this.m_dbPopulator.getDistPollerDao().save((Object)distPoller);
            this.m_dbPopulator.getDistPollerDao().flush();
        }
        return distPoller;
    }

    @Test
    @JUnitTemporaryDatabase
    public void testEventIdFilter() {
        EventIdFilter filter = new EventIdFilter(1);
        this.assert1Result((Filter)filter);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testEventIdListFilter() {
        int[] ids = new int[]{1};
        EventIdListFilter filter = new EventIdListFilter(ids);
        this.assert1Result((Filter)filter);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAcknowledgeByFilter() {
        AcknowledgedByFilter filter = new AcknowledgedByFilter("TestUser");
        EventCriteria criteria = new EventCriteria(new Filter[]{filter});
        Event[] events = this.m_daoEventRepo.getMatchingEvents(criteria);
        Assert.assertEquals((long)0L, (long)events.length);
        this.m_daoEventRepo.acknowledgeMatchingEvents("TestUser", new Date(), new EventCriteria(new Filter[]{new EventIdFilter(1)}));
        events = this.m_daoEventRepo.getMatchingEvents(criteria);
        Assert.assertEquals((long)1L, (long)events.length);
        Assert.assertEquals((Object)"TestUser", (Object)events[0].getAcknowledgeUser());
        this.m_daoEventRepo.unacknowledgeAll();
        events = this.m_jdbcEventRepo.getMatchingEvents(criteria);
        Assert.assertEquals((long)0L, (long)events.length);
        this.m_daoEventRepo.acknowledgeAll("TestUser", new Date());
        events = this.m_jdbcEventRepo.getMatchingEvents(criteria);
        Assert.assertEquals((long)2L, (long)events.length);
    }

    @Test
    @Transactional
    public void testAfterDateFilter() {
        AfterDateFilter filter = new AfterDateFilter(WebEventRepositoryFilterTest.yesterday());
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAlarmIdFilter() {
        AlarmIdFilter filter = new AlarmIdFilter(1);
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
    }

    @Test
    @Transactional
    public void testBeforeDateFilter() {
        BeforeDateFilter filter = new BeforeDateFilter(new Date());
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
    }

    @Test
    @Transactional
    public void testDescriptionSubstringFilterTest() {
        DescriptionSubstringFilter filter = new DescriptionSubstringFilter("test event");
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        Assert.assertEquals((Object)"This is a test event", (Object)events[0].getDescription());
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        Assert.assertEquals((Object)"This is a test event", (Object)events[0].getDescription());
    }

    @Test
    @Transactional
    public void testExactUEIFilter() {
        ExactUEIFilter filter = new ExactUEIFilter("uei.opennms.org/test2");
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        Assert.assertEquals((Object)"uei.opennms.org/test2", (Object)events[0].getUei());
        events = this.getMatchingJdbcEvents(new Filter[]{new ExactUEIFilter("uei.opennms.org/test")});
        Assert.assertEquals((long)1L, (long)events.length);
        Assert.assertEquals((Object)"uei.opennms.org/test", (Object)events[0].getUei());
    }

    @Test
    @Transactional
    public void testIfIndexFilter() {
        IfIndexFilter filter = new IfIndexFilter(11);
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        events = this.getMatchingDaoEvents(new Filter[]{new IfIndexFilter(1)});
        Assert.assertEquals((long)0L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{new IfIndexFilter(1)});
        Assert.assertEquals((long)0L, (long)events.length);
    }

    @Test
    @Transactional
    public void testInterfaceFilter() {
        InterfaceFilter filter = new InterfaceFilter("192.168.1.1");
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        Assert.assertEquals((Object)"192.168.1.1", (Object)events[0].getIpAddress());
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        Assert.assertEquals((Object)"192.168.1.1", (Object)events[0].getIpAddress());
    }

    @Test
    @Transactional
    public void testIpAddrLikeFilter() {
        IPAddrLikeFilter filter = new IPAddrLikeFilter("192.168.*.*");
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        filter = new IPAddrLikeFilter("193.168");
        events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)0L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)0L, (long)events.length);
    }

    @Test
    @Transactional
    public void testLogMessageMatchesAny() {
        LogMessageMatchesAnyFilter filter = new LogMessageMatchesAnyFilter("This is a");
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        events = null;
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
    }

    @Test
    @Transactional
    public void testLogMessageSubstringFilter() {
        LogMessageSubstringFilter filter = new LogMessageSubstringFilter("is a test");
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
    }

    @Test
    @Transactional
    public void testNegativeAcknowledgedByFilter() {
        NegativeAcknowledgedByFilter filter = new NegativeAcknowledgedByFilter("TestUser");
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
        events = null;
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
        this.m_daoEventRepo.acknowledgeAll("TestUser", new Date());
        events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)0L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)0L, (long)events.length);
    }

    @Test
    @Transactional
    public void testNegativeExactUeiFilter() {
        NegativeExactUEIFilter filter = new NegativeExactUEIFilter("uei.opennms.org/test2");
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        filter = new NegativeExactUEIFilter("uei.opennms.org/nontest");
        events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
    }

    @Test
    @Transactional
    public void testNegativeInterfaceFilter() {
        NegativeInterfaceFilter filter = new NegativeInterfaceFilter("192.168.1.1");
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        filter = new NegativeInterfaceFilter("27.0.0.1");
        events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
    }

    @Test
    @Transactional
    public void testNegativeNodeFilter() {
        NegativeNodeFilter filter = new NegativeNodeFilter(this.m_dbPopulator.getNode2().getId().intValue(), this.m_appContext);
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
        filter = new NegativeNodeFilter(this.m_dbPopulator.getNode1().getId().intValue(), this.m_appContext);
        events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        Assert.assertEquals((Object)"node is not node1", (Object)filter.getTextDescription());
    }

    @Test
    @Transactional
    public void testNegativePartialUeiFilter() {
        NegativePartialUEIFilter filter = new NegativePartialUEIFilter("uei.opennms.org");
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)0L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)0L, (long)events.length);
        filter = new NegativePartialUEIFilter("puei.org.opennms");
        events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNegativeServiceFilter() {
        NegativeServiceFilter filter = new NegativeServiceFilter(1, this.m_appContext);
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        filter = new NegativeServiceFilter(2, this.m_appContext);
        events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
    }

    @Test
    @Transactional
    public void testNegativeSeverityFilter() {
        NegativeSeverityFilter filter = new NegativeSeverityFilter(OnmsSeverity.CRITICAL.getId());
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
        filter = new NegativeSeverityFilter(OnmsSeverity.CLEARED.getId());
        events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNodeFilter() {
        NodeFilter filter = new NodeFilter(1, this.m_appContext);
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        filter = new NodeFilter(2, this.m_appContext);
        events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)0L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)0L, (long)events.length);
        Assert.assertEquals((Object)"node=node2", (Object)filter.getTextDescription());
    }

    @Test
    @Transactional
    public void testNodeNameLikeFilter() {
        NodeNameLikeFilter filter = new NodeNameLikeFilter("node1");
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        filter = new NodeNameLikeFilter("testNode");
        events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)0L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)0L, (long)events.length);
    }

    @Test
    @Transactional
    public void testPartialUeiFilter() {
        PartialUEIFilter filter = new PartialUEIFilter("uei.opennms.org/t");
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)2L, (long)events.length);
        filter = new PartialUEIFilter("unknown");
        events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)0L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)0L, (long)events.length);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testServiceFilter() {
        ServiceFilter filter = new ServiceFilter(2, this.m_appContext);
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)0L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)0L, (long)events.length);
        filter = new ServiceFilter(1, this.m_appContext);
        events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
    }

    @Test
    @Transactional
    public void testSeverityFilter() {
        SeverityFilter filter = new SeverityFilter(OnmsSeverity.CLEARED.getId());
        Event[] events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)1L, (long)events.length);
        filter = new SeverityFilter(OnmsSeverity.MAJOR.getId());
        events = this.getMatchingDaoEvents(new Filter[]{filter});
        Assert.assertEquals((long)0L, (long)events.length);
        events = this.getMatchingJdbcEvents(new Filter[]{filter});
        Assert.assertEquals((long)0L, (long)events.length);
    }

    private static EventCriteria getCriteria(Filter ... filters) {
        return new EventCriteria(filters);
    }

    private Event[] getMatchingDaoEvents(Filter ... filters) {
        return this.m_daoEventRepo.getMatchingEvents(WebEventRepositoryFilterTest.getCriteria(filters));
    }

    private Event[] getMatchingJdbcEvents(Filter ... filters) {
        return this.m_jdbcEventRepo.getMatchingEvents(WebEventRepositoryFilterTest.getCriteria(filters));
    }

    private void assert1Result(Filter filter) {
        EventCriteria criteria = new EventCriteria(new Filter[]{filter});
        Event[] events = this.m_jdbcEventRepo.getMatchingEvents(criteria);
        Assert.assertEquals((long)1L, (long)events.length);
        events = this.m_daoEventRepo.getMatchingEvents(criteria);
        Assert.assertEquals((long)1L, (long)events.length);
    }

    private static Date yesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }
}

