/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm.filter;

import java.util.Date;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.alarm.Alarm;
import org.opennms.web.alarm.WebAlarmRepository;
import org.opennms.web.alarm.filter.AfterFirstEventTimeFilter;
import org.opennms.web.alarm.filter.AlarmCriteria;
import org.opennms.web.alarm.filter.AlarmTypeFilter;
import org.opennms.web.alarm.filter.BeforeFirstEventTimeFilter;
import org.opennms.web.alarm.filter.BeforeLastEventTimeFilter;
import org.opennms.web.alarm.filter.DescriptionSubstringFilter;
import org.opennms.web.alarm.filter.EventParmLikeFilter;
import org.opennms.web.alarm.filter.ExactUEIFilter;
import org.opennms.web.alarm.filter.IPAddrLikeFilter;
import org.opennms.web.alarm.filter.InterfaceFilter;
import org.opennms.web.alarm.filter.LogMessageMatchesAnyFilter;
import org.opennms.web.alarm.filter.LogMessageSubstringFilter;
import org.opennms.web.alarm.filter.NegativeAcknowledgedByFilter;
import org.opennms.web.alarm.filter.NegativeEventParmLikeFilter;
import org.opennms.web.alarm.filter.NegativeExactUEIFilter;
import org.opennms.web.alarm.filter.NegativeInterfaceFilter;
import org.opennms.web.alarm.filter.NegativeNodeFilter;
import org.opennms.web.alarm.filter.NegativePartialUEIFilter;
import org.opennms.web.alarm.filter.NegativeServiceFilter;
import org.opennms.web.alarm.filter.NegativeSeverityFilter;
import org.opennms.web.alarm.filter.NodeNameLikeFilter;
import org.opennms.web.alarm.filter.ServiceFilter;
import org.opennms.web.alarm.filter.SeverityBetweenFilter;
import org.opennms.web.filter.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/daoWebRepositoryTestContext.xml", "classpath:/jdbcWebRepositoryTestContext.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class WebAlarmRepositoryFilterTest
implements InitializingBean {
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    @Qualifier(value="dao")
    WebAlarmRepository m_daoAlarmRepo;
    @Autowired
    @Qualifier(value="jdbc")
    WebAlarmRepository m_jdbcWebAlarmRepo;
    @Autowired
    ApplicationContext m_appContext;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_dbPopulator.populateDatabase();
    }

    @After
    public void tearDown() {
    }

    @Test
    @Transactional
    public void testAlarmTypeFilter() {
        Alarm[] alarm = this.m_daoAlarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new AlarmTypeFilter(3)}));
        Assert.assertEquals((long)0L, (long)alarm.length);
        alarm = this.m_jdbcWebAlarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new AlarmTypeFilter(3)}));
        Assert.assertEquals((long)0L, (long)alarm.length);
        alarm = this.m_daoAlarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new AlarmTypeFilter(1)}));
        Assert.assertEquals((long)1L, (long)alarm.length);
        alarm = this.m_jdbcWebAlarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new AlarmTypeFilter(1)}));
        Assert.assertEquals((long)1L, (long)alarm.length);
    }

    @Test
    @Transactional
    public void testBeforeFirstEventTimeFilter() {
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new BeforeFirstEventTimeFilter(new Date())}));
        Assert.assertEquals((long)1L, (long)alarms.length);
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new BeforeFirstEventTimeFilter(new Date())}));
        Assert.assertEquals((long)1L, (long)alarms.length);
        alarms = this.m_daoAlarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new BeforeLastEventTimeFilter(new Date())}));
        Assert.assertEquals((long)1L, (long)alarms.length);
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new BeforeLastEventTimeFilter(new Date())}));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testBeforeLastEventTime() {
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new BeforeLastEventTimeFilter(new Date())}));
        Assert.assertEquals((long)1L, (long)alarms.length);
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new BeforeLastEventTimeFilter(new Date())}));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testExactUeiFilter() {
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new ExactUEIFilter("test uei")}));
        Assert.assertEquals((long)0L, (long)alarms.length);
        alarms = this.m_daoAlarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new ExactUEIFilter("uei.opennms.org/test")}));
        Assert.assertEquals((long)1L, (long)alarms.length);
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new ExactUEIFilter("test uei")}));
        Assert.assertEquals((long)0L, (long)alarms.length);
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new ExactUEIFilter("uei.opennms.org/test")}));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testInterfaceFilter() {
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new InterfaceFilter("192.168.1.1")}));
        Assert.assertEquals((long)1L, (long)alarms.length);
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new InterfaceFilter("192.168.1.1")}));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testNegativeAcknowledgeByFilter() {
        AlarmCriteria criteria = new AlarmCriteria(new Filter[]{new NegativeAcknowledgedByFilter("non user")});
        Alarm[] alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
        alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testIPLikeFilter() {
        AlarmCriteria criteria = new AlarmCriteria(new Filter[]{new IPAddrLikeFilter("192.168.1.1")});
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
        Assert.assertEquals((Object)"192.168.1.1", (Object)alarms[0].getIpAddress());
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
        Assert.assertEquals((Object)"192.168.1.1", (Object)alarms[0].getIpAddress());
    }

    @Test
    @Transactional
    public void testNegativeInterfaceFilter() {
        AlarmCriteria criteria = new AlarmCriteria(new Filter[]{new NegativeInterfaceFilter("192.168.1.101")});
        Alarm[] alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
        alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testNegativeNodeFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new NegativeNodeFilter(11, this.m_appContext)});
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
        NegativeNodeFilter filter = new NegativeNodeFilter(11, this.m_appContext);
        Assert.assertEquals((Object)"node is not 11", (Object)filter.getTextDescription());
    }

    @Test
    @Transactional
    public void testNegativeExactUeiFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new NegativeExactUEIFilter("uei.opennms.org/bogus")});
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testNegativePartialUEIFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new NegativePartialUEIFilter("uei.opennms.org")});
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)0L, (long)alarms.length);
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)0L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testNegativeServiceFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new NegativeServiceFilter(12)});
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testNegativeSeverityFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new NegativeSeverityFilter(OnmsSeverity.CRITICAL)});
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testNodeNameLikeFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new NodeNameLikeFilter("mr")});
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)0L, (long)alarms.length);
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)0L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testSeverityBetweenFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new SeverityBetweenFilter(OnmsSeverity.CLEARED, OnmsSeverity.MAJOR)});
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testServiceFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new ServiceFilter(1)});
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)0L, (long)alarms.length);
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)0L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testAfterFirstEventTime() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new AfterFirstEventTimeFilter(new Date())});
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)0L, (long)alarms.length);
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)0L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testDescriptionSubstringFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new DescriptionSubstringFilter("alarm")});
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testLogMessageSubstringFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new LogMessageSubstringFilter("this is a test")});
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testLogMessageMatchAnyFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new LogMessageMatchesAnyFilter("log")});
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
        alarms = this.m_jdbcWebAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testParmsLikeFilter() {
        List events = this.m_dbPopulator.getEventDao().findAll();
        Assert.assertNotNull((Object)events);
        OnmsEvent event = (OnmsEvent)events.get(0);
        List pollers = this.m_dbPopulator.getDistPollerDao().findAll();
        Assert.assertNotNull((Object)pollers);
        OnmsDistPoller poller = (OnmsDistPoller)pollers.get(0);
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setUei("uei.opennms.org/vendor/Juniper/traps/jnxVpnIfUp");
        alarm.setLastEvent(event);
        alarm.setSeverityId(Integer.valueOf(3));
        alarm.setDistPoller(poller);
        alarm.setCounter(Integer.valueOf(100));
        alarm.setEventParms("url=http://localhost:8980/opennms/rtc/post/Network+Interfaces(string,text);user=rtc(string,text);passwd=rtc(string,text);catlabel=Network Interfaces(string,text)");
        AlarmDao alarmDao = this.m_dbPopulator.getAlarmDao();
        alarmDao.save((Object)alarm);
        alarmDao.flush();
        OnmsAlarm alarm2 = new OnmsAlarm();
        alarm2.setUei("uei.opennms.org/vendor/Juniper/traps/jnxVpnIfUp");
        alarm2.setLastEvent(event);
        alarm2.setSeverityId(Integer.valueOf(3));
        alarm2.setDistPoller(poller);
        alarm2.setCounter(Integer.valueOf(100));
        alarm2.setEventParms("componentType=serviceElement(string,text);url=http://localhost:8980/opennms/rtc/post/Network+Interfaces(string,text);user=rtcbomb(string,text);passwd=rtc(string,text);catlabel=Network Interfaces(string,text)");
        alarmDao.save((Object)alarm2);
        alarmDao.flush();
        EventParmLikeFilter eventParmFilter = new EventParmLikeFilter("user=rtc");
        Assert.assertEquals((Object)"user=\"rtc\"", (Object)eventParmFilter.getTextDescription());
        AlarmCriteria criteria = new AlarmCriteria(new Filter[]{eventParmFilter});
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    public void testParmsNotLikeFilter() {
        List events = this.m_dbPopulator.getEventDao().findAll();
        Assert.assertNotNull((Object)events);
        OnmsEvent event = (OnmsEvent)events.get(0);
        List pollers = this.m_dbPopulator.getDistPollerDao().findAll();
        Assert.assertNotNull((Object)pollers);
        OnmsDistPoller poller = (OnmsDistPoller)pollers.get(0);
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setUei("uei.opennms.org/vendor/Juniper/traps/jnxVpnIfUp");
        alarm.setLastEvent(event);
        alarm.setSeverityId(Integer.valueOf(3));
        alarm.setDistPoller(poller);
        alarm.setCounter(Integer.valueOf(100));
        alarm.setEventParms("componentType=service(string,text);url=http://localhost:8980/opennms/rtc/post/Network+Interfaces(string,text);user=rtc(string,text);passwd=rtc(string,text);catlabel=Network Interfaces(string,text)");
        AlarmDao alarmDao = this.m_dbPopulator.getAlarmDao();
        alarmDao.save((Object)alarm);
        alarmDao.flush();
        OnmsAlarm alarm2 = new OnmsAlarm();
        alarm2.setUei("uei.opennms.org/vendor/Juniper/traps/jnxVpnIfUp");
        alarm2.setLastEvent(event);
        alarm2.setSeverityId(Integer.valueOf(3));
        alarm2.setDistPoller(poller);
        alarm2.setCounter(Integer.valueOf(100));
        alarm2.setEventParms("componentType=serviceElement(string,text);url=http://localhost:8980/opennms/rtc/post/Network+Interfaces(string,text);user=admin(string,text);passwd=rtc(string,text);catlabel=Network Interfaces(string,text)");
        alarmDao.save((Object)alarm2);
        alarmDao.flush();
        NegativeEventParmLikeFilter parmFilter = new NegativeEventParmLikeFilter("user=rtc");
        Assert.assertEquals((Object)"user is not \"rtc\"", (Object)parmFilter.getTextDescription());
        AlarmCriteria criteria = new AlarmCriteria(new Filter[]{parmFilter});
        Alarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    private AlarmCriteria getCriteria(Filter ... filters) {
        return new AlarmCriteria(filters);
    }
}

