/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.roles;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.config.AbstractTimeIntervalSequence;
import org.opennms.netmgt.config.GroupFactory;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.IntervalTestCase;
import org.opennms.netmgt.config.OwnedInterval;
import org.opennms.netmgt.config.OwnedIntervalSequence;
import org.opennms.netmgt.config.Owner;
import org.opennms.netmgt.config.TimeInterval;
import org.opennms.netmgt.config.UserFactory;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.config.groups.Role;
import org.opennms.netmgt.config.users.User;
import org.opennms.netmgt.notifd.mock.MockGroupManager;
import org.opennms.netmgt.notifd.mock.MockUserManager;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.web.admin.roles.AppContext;
import org.opennms.web.admin.roles.MonthlyCalendar;
import org.opennms.web.admin.roles.WebGroup;
import org.opennms.web.admin.roles.WebGroupManager;
import org.opennms.web.admin.roles.WebRole;
import org.opennms.web.admin.roles.WebRoleManager;
import org.opennms.web.admin.roles.WebUser;
import org.opennms.web.admin.roles.WebUserManager;

public class RolesTest
extends IntervalTestCase {
    private GroupManager m_groupManager;
    private UserManager m_userManager;
    private WebRoleManager m_roleMgr;
    private WebGroupManager m_groupMgr;
    private WebUserManager m_userMgr;

    protected void setUp() throws Exception {
        super.setUp();
        MockLogAppender.setupLogging();
        this.m_groupManager = new MockGroupManager(ConfigurationTestUtils.getConfigForResourceWithReplacements((Object)((Object)this), (String)"/org/opennms/netmgt/config/groups.xml", (String[][])new String[0][]));
        this.m_userManager = new MockUserManager(this.m_groupManager, ConfigurationTestUtils.getConfigForResourceWithReplacements((Object)((Object)this), (String)"/org/opennms/netmgt/config/users.xml", (String[][])new String[0][]));
        GroupFactory.setInstance((GroupManager)this.m_groupManager);
        UserFactory.setInstance((UserManager)this.m_userManager);
        this.m_roleMgr = AppContext.getWebRoleManager();
        this.m_groupMgr = AppContext.getWebGroupManager();
        this.m_userMgr = AppContext.getWebUserManager();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRoles() throws Exception {
        RolesTest.assertNotNull((Object)this.m_roleMgr);
        RolesTest.assertNotNull((Object)this.m_roleMgr.getRoles());
        String[] roleNames = this.m_groupManager.getRoleNames();
        RolesTest.assertEquals((int)roleNames.length, (int)this.m_roleMgr.getRoles().size());
        for (int i = 0; i < roleNames.length; ++i) {
            String roleName = roleNames[i];
            Role role = this.m_groupManager.getRole(roleName);
            WebRole webRole = this.m_roleMgr.getRole(roleName);
            RolesTest.assertNotNull((Object)webRole);
            this.assertRole(role, webRole);
        }
        for (String groupName : this.m_groupManager.getGroupNames()) {
            Group group = this.m_groupManager.getGroup(groupName);
            WebGroup webGroup = this.m_groupMgr.getGroup(groupName);
            this.assertGroup(group, webGroup);
        }
        for (String userName : this.m_userManager.getUserNames()) {
            User user = this.m_userManager.getUser(userName);
            WebUser webUser = this.m_userMgr.getUser(userName);
            this.assertUser(user, webUser);
        }
        WebRole oncall = this.m_roleMgr.getRole("oncall");
        RolesTest.assertEquals((String)"oncall", (String)oncall.getName());
        RolesTest.assertEquals((Object)this.m_groupMgr.getGroup("InitialGroup"), (Object)oncall.getMembershipGroup());
    }

    public void testWeekCount() throws Exception {
        Date aug3 = this.getDate("2005-08-03");
        MonthlyCalendar calendar = new MonthlyCalendar(aug3, null, null);
        RolesTest.assertEquals((int)5, (int)calendar.getWeeks().length);
        Date july17 = this.getDate("2005-07-17");
        calendar = new MonthlyCalendar(july17, null, null);
        RolesTest.assertEquals((int)6, (int)calendar.getWeeks().length);
        Date may27 = this.getDate("2005-05-27");
        calendar = new MonthlyCalendar(may27, null, null);
        RolesTest.assertEquals((int)5, (int)calendar.getWeeks().length);
        Date feb14_04 = this.getDate("2004-02-14");
        calendar = new MonthlyCalendar(feb14_04, null, null);
        RolesTest.assertEquals((int)5, (int)calendar.getWeeks().length);
        Date feb7_09 = this.getDate("2009-02-09");
        calendar = new MonthlyCalendar(feb7_09, null, null);
        RolesTest.assertEquals((int)4, (int)calendar.getWeeks().length);
    }

    public void testTimeIntervals() throws Exception {
        OwnedIntervalSequence intervals = this.m_groupManager.getRoleScheduleEntries("oncall", this.getDate("2005-08-18"), this.getDate("2005-08-19"));
        RolesTest.assertNotNull((Object)intervals);
        Owner brozow = new Owner("oncall", "brozow", 1, 1);
        Owner admin = new Owner("oncall", "admin", 1, 1);
        Owner david = new Owner("oncall", "david", 1, 1);
        OwnedIntervalSequence before = new OwnedIntervalSequence();
        before.addInterval((TimeInterval)this.owned(david, this.aug(18, 0, 9)));
        before.addInterval((TimeInterval)this.owned(admin, this.aug(18, 9, 17)));
        before.addInterval((TimeInterval)this.owned(david, this.aug(18, 17, 23)));
        before.addInterval((TimeInterval)this.owned(brozow, this.aug(18, 23, 24)));
        OwnedInterval[] expected = new OwnedInterval[]{this.owned(david, this.aug(18, 0, 9)), this.owned(admin, this.aug(18, 9, 17)), this.owned(david, this.aug(18, 17, 23)), this.owned(brozow, this.aug(18, 23, 24))};
        this.assertTimeIntervalSequence((TimeInterval[])expected, (AbstractTimeIntervalSequence)intervals);
    }

    private void assertUser(User user, WebUser webUser) {
        RolesTest.assertEquals((String)user.getUserId(), (String)webUser.getName());
    }

    private void assertGroup(Group group, WebGroup webGroup) throws Exception {
        RolesTest.assertEquals((String)group.getName(), (String)webGroup.getName());
        List userNames = group.getUserCollection();
        RolesTest.assertEquals((int)userNames.size(), (int)webGroup.getUsers().size());
        for (WebUser user : webGroup.getUsers()) {
            RolesTest.assertTrue((boolean)userNames.contains(user.getName()));
            this.assertUser(this.m_userManager.getUser(user.getName()), user);
        }
    }

    private void assertRole(Role role, WebRole webRole) throws Exception {
        RolesTest.assertEquals((String)role.getName(), (String)webRole.getName());
        RolesTest.assertEquals((String)role.getDescription(), (String)webRole.getDescription());
        RolesTest.assertNotNull((Object)webRole.getMembershipGroup());
        RolesTest.assertEquals((String)role.getMembershipGroup(), (String)webRole.getMembershipGroup().getName());
        RolesTest.assertNotNull((Object)webRole.getDefaultUser());
        RolesTest.assertEquals((String)role.getSupervisor(), (String)webRole.getDefaultUser().getName());
        Collection scheduledUsers = webRole.getCurrentUsers();
        for (WebUser currentUser : scheduledUsers) {
            RolesTest.assertTrue((boolean)this.m_groupManager.isUserScheduledForRole(currentUser.getName(), webRole.getName(), new Date()));
        }
    }

    private Date getDate(String date) throws ParseException {
        return new SimpleDateFormat("yyyy-MM-dd").parse(date);
    }
}

