/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gwt.web.ui.asset.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.opennms.gwt.web.ui.asset.client.AssetService;
import org.opennms.gwt.web.ui.asset.shared.AssetCommand;
import org.opennms.gwt.web.ui.asset.shared.AssetSuggCommand;

public class AssetServiceMockup
extends RemoteServiceServlet
implements AssetService {
    private static final long serialVersionUID = 386558445935186134L;
    private AssetCommand asset = new AssetCommand();
    private SimpleDateFormat onmsFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private AssetSuggCommand assetSugg = new AssetSuggCommand();

    public AssetServiceMockup() {
        this.setData();
    }

    public AssetCommand getAssetByNodeId(int nodeId) throws Exception {
        if (nodeId == 666) {
            throw new NullPointerException("just testing error-case: nodeid 666");
        }
        return this.asset;
    }

    public Boolean saveOrUpdateAssetByNodeId(int nodeId, AssetCommand asset) throws Exception {
        if (nodeId == 999) {
            throw new NullPointerException("just testing error-case: nodeid 999, you will not save!!");
        }
        this.asset = asset;
        this.assetSugg.addCpu(asset.getCpu());
        this.assetSugg.addAdditionalhardware(asset.getAdditionalhardware());
        asset.setLastModifiedDate(new Date());
        asset.setLastModifiedBy("admin");
        return true;
    }

    public AssetCommand setData() {
        this.asset.setNodeId("23");
        this.asset.setNodeLabel("Cronojon");
        this.asset.setLoggedInUser("admin");
        this.saveDataSNMP();
        this.saveDataConfigCategories();
        this.saveDataIdentification();
        this.saveDataLocation();
        this.saveDataVendor();
        this.saveDataAuthentication();
        this.saveDataHardware();
        this.saveDataComments();
        this.asset.setLastModifiedBy("admin");
        this.asset.setLastModifiedDate(new Date());
        return this.asset;
    }

    private void saveDataSNMP() {
        this.asset.setSnmpSysObjectId(".1.3.6.1.4.1.8072.3.2.10");
        this.asset.setSnmpSysName("tak-ThinkPad-X200s");
        this.asset.setSnmpSysLocation("Sitting on the Dock of the Bay");
        this.asset.setSnmpSysContact("Me <me@example.org>");
        this.asset.setSnmpSysDescription("Linux tak-ThinkPad-X200s 2.6.35-28-generic #50-Ubuntu SMP Fri Mar 18 18:42:20 UTC 2011 x86_64");
    }

    private void saveDataConfigCategories() {
        this.asset.setDisplayCategory("DisplayCategory");
        this.asset.setNotifyCategory("NotifyCategory");
        this.asset.setPollerCategory("PollerCategory");
        this.asset.setThresholdCategory("ThresholdCategory");
    }

    private void saveDataIdentification() {
        Date installDate;
        this.asset.setDescription("Description");
        this.asset.setCategory("Category");
        this.asset.setManufacturer("Manufacturer");
        this.asset.setModelNumber("ModelNumber");
        this.asset.setSerialNumber("SerialNumber");
        this.asset.setAssetNumber("AssetNumber");
        this.asset.setOperatingSystem("OperatingSystem");
        try {
            installDate = this.onmsFormatter.parse("2000-12-27");
        }
        catch (ParseException e) {
            e.printStackTrace();
            installDate = new Date();
        }
        this.asset.setDateInstalled(this.onmsFormatter.format(installDate));
    }

    private void saveDataLocation() {
        this.asset.setRegion("Region");
        this.asset.setDivision("Division");
        this.asset.setDepartment("Department");
        this.asset.setAddress1("Address1");
        this.asset.setAddress2("Address2");
        this.asset.setCity("City");
        this.asset.setState("State");
        this.asset.setZip("Zip");
        this.asset.setBuilding("Building");
        this.asset.setFloor("Floor");
        this.asset.setRoom("Room");
        this.asset.setRack("Rack");
        this.asset.setSlot("Slot");
        this.asset.setPort("Port");
        this.asset.setCircuitId("CircuitId");
    }

    private void saveDataVendor() {
        Date maintConExp;
        this.asset.setVendor("Vendor");
        this.asset.setVendorPhone("VendorPhone");
        this.asset.setVendorFax("VendorFax");
        this.asset.setLease("Lease");
        this.asset.setLeaseExpires("FooDate");
        this.asset.setVendorAssetNumber("VendorAssetNumber");
        this.asset.setMaintcontract("423423423_contract+Plus");
        try {
            maintConExp = this.onmsFormatter.parse("2000-12-27");
        }
        catch (ParseException e) {
            e.printStackTrace();
            maintConExp = new Date();
        }
        this.asset.setMaintContractExpiration(this.onmsFormatter.format(maintConExp));
        this.asset.setSupportPhone("SupportPhone");
    }

    private void saveDataAuthentication() {
        this.asset.setUsername("Username");
        this.asset.setPassword("Password");
        this.asset.setEnable("Enable");
        this.asset.setConnection("");
        ArrayList<String> connectionOptions = new ArrayList<String>();
        connectionOptions.add("");
        connectionOptions.add("telnet");
        connectionOptions.add("ssh");
        connectionOptions.add("rsh");
        this.asset.setConnectionOptions(connectionOptions);
        this.asset.setAutoenable("");
        ArrayList<String> autoenableOptions = new ArrayList<String>();
        autoenableOptions.add("");
        autoenableOptions.add("A");
        this.asset.setAutoenableOptions(autoenableOptions);
    }

    private void saveDataHardware() {
        this.asset.setCpu("Intel Centrino2");
        this.asset.setRam("8GB DDR3");
        this.asset.setStoragectrl("SATA");
        this.asset.setAdditionalhardware("Rocket-Tower");
        this.asset.setNumpowersupplies("1");
        this.asset.setInputpower("2400 W");
        this.asset.setHdd1("for Comics");
        this.asset.setHdd2("for Musik");
        this.asset.setHdd3("for Games");
        this.asset.setHdd4("for Programs");
        this.asset.setHdd5("for Chaos");
        this.asset.setHdd6("for failing");
    }

    private void saveDataComments() {
        this.asset.setComment("Es soll manchen Dichter geben, der muss dichten, um zu leben.Ist das immer so? Mitnichten,manche leben um zu dichten.");
    }

    public AssetSuggCommand getAssetSuggestions() throws Exception {
        this.assetSugg.addDescription("001");
        this.assetSugg.addDescription("001");
        this.assetSugg.addDescription("002");
        this.assetSugg.addDescription("003");
        this.assetSugg.addDescription("004");
        this.assetSugg.addCategory("allo");
        this.assetSugg.addCategory("aallo");
        this.assetSugg.addCategory("ballo");
        this.assetSugg.addCategory("callo");
        this.assetSugg.addCpu("AMD");
        this.assetSugg.addCpu("ARM");
        this.assetSugg.addCpu("INTEL");
        this.assetSugg.addCpu("MOTOROLA");
        this.assetSugg.addAdditionalhardware("Laser-Canon");
        this.assetSugg.addAdditionalhardware("Magic-Door");
        this.assetSugg.addAdditionalhardware("Blackhole-Port");
        this.assetSugg.addAdmin("Super Mario");
        this.assetSugg.addAdmin("Medium Mario");
        this.assetSugg.addAdmin("Bad Mario");
        this.assetSugg.addAdmin("Pure Mario");
        this.assetSugg.addManufacturer("Atari");
        this.assetSugg.addManufacturer("Atari");
        this.assetSugg.addManufacturer("Bell-Labs");
        this.assetSugg.addManufacturer("Comodore");
        this.assetSugg.addManufacturer("Dell");
        this.assetSugg.addSnmpcommunity("public");
        this.assetSugg.addSnmpcommunity("not so public");
        this.assetSugg.addSnmpcommunity("private");
        return this.assetSugg;
    }
}

