/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2006-2011 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2011 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;

/**
 * Encapsulates all interface filtering functionality.
 *
 * @deprecated This filter is not IPv6 compatible.
 *
 * @author ranger
 * @version $Id: $
 * @since 1.8.1
 */
public class IPLikeFilter extends Object implements Filter {
    /** Constant <code>TYPE="iplike"</code> */
    public static final String TYPE = "iplike";

    protected String ipLikePattern;

    /**
     * <p>Constructor for IPLikeFilter.</p>
     *
     * @param ipLikePattern a {@link java.lang.String} object.
     */
    public IPLikeFilter(String ipLikePattern) {
        if (ipLikePattern == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }

        this.ipLikePattern = ipLikePattern;
    }

    /**
     * <p>getSql</p>
     *
     * @deprecated This function will produce invalid SQL for some IPv6 addresses.
     *
     * @return a {@link java.lang.String} object.
     */
    public String getSql() {
        return (" IPLIKE(IPADDR,'" + this.ipLikePattern + "')");
    }
    
    /**
     * <p>getParamSql</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getParamSql() {
        return (" IPLIKE(IPADDR,?)");
    }
    
    /** {@inheritDoc} */
    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
    	ps.setString(parameterIndex, this.ipLikePattern);
    	return 1;
    }

    /**
     * <p>getDescription</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getDescription() {
        return (TYPE + "=" + this.ipLikePattern);
    }

    /**
     * <p>getTextDescription</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getTextDescription() {
        return ("IP Address like \"" + this.ipLikePattern + "\"");
    }

    /**
     * <p>toString</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        return ("<Vulnerability IPLike Filter: " + this.getDescription() + ">");
    }

    /**
     * <p>Getter for the field <code>ipLikePattern</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getIpLikePattern() {
        return (this.ipLikePattern);
    }

    /** {@inheritDoc} */
    public boolean equals(Object obj) {
        return (this.toString().equals(obj.toString()));
    }
}
