/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2011 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2011 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/


package org.opennms.gwt.web.ui.asset.client.tools.validation;

import org.opennms.gwt.web.ui.asset.client.AssetPageConstants;

import com.google.gwt.core.client.GWT;

/**
 * @author <a href="mailto:MarkusNeumannMarkus@gmail.com">Markus Neumann</a>
 *         Validates length of a String against a maximum.
 */
public class StringMaxLengthValidator implements Validator {
	private AssetPageConstants con = GWT.create(AssetPageConstants.class);
	private int maxLength;

	public StringMaxLengthValidator(int maxLength) {
		this.maxLength = maxLength;
	}

	/**
	 * The defined maximum for a valid string length.
	 * 
	 * @return int maxLength
	 */
	public int getMaxLength() {
		return maxLength;
	}

	/**
	 * Validates length of a String against a maximum. Validation will run
	 * against <code>(String) object</code> so make sure to use a proper object.
	 * 
	 * @param object
	 */
	@Override
	public String validate(Object object) {
		if (((String) object).length() > maxLength) {
			return con.stringToLongError() + " " + maxLength;
		}
		return "";
	}
}
