/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.servlet.ServletContext;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.vulnerability.filter.Filter;

public class NodeFilter
implements Filter {
    public static final String TYPE = "node";
    protected int nodeId;
    private ServletContext m_servletContext;

    public NodeFilter(int nodeId, ServletContext servletContext) {
        this.nodeId = nodeId;
        this.m_servletContext = servletContext;
    }

    @Override
    public String getSql() {
        return " VULNERABILITIES.NODEID=" + this.nodeId;
    }

    @Override
    public String getParamSql() {
        return " VULNERABILITIES.NODEID=?";
    }

    @Override
    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        ps.setInt(parameterIndex, this.nodeId);
        return 1;
    }

    @Override
    public String getDescription() {
        return "node=" + this.nodeId;
    }

    @Override
    public String getTextDescription() {
        String nodeName = NetworkElementFactory.getInstance(this.m_servletContext).getNodeLabel(this.nodeId);
        if (nodeName == null) {
            nodeName = Integer.toString(this.nodeId);
        }
        return "node is " + nodeName;
    }

    public String toString() {
        return "<Vulnerability Node Filter: " + this.getDescription() + ">";
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

