/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.opennms.web.vulnerability.filter.Filter;

public class IPLikeFilter
implements Filter {
    public static final String TYPE = "iplike";
    protected String ipLikePattern;

    public IPLikeFilter(String ipLikePattern) {
        if (ipLikePattern == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.ipLikePattern = ipLikePattern;
    }

    @Override
    public String getSql() {
        return " IPLIKE(IPADDR,'" + this.ipLikePattern + "')";
    }

    @Override
    public String getParamSql() {
        return " IPLIKE(IPADDR,?)";
    }

    @Override
    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        ps.setString(parameterIndex, this.ipLikePattern);
        return 1;
    }

    @Override
    public String getDescription() {
        return "iplike=" + this.ipLikePattern;
    }

    @Override
    public String getTextDescription() {
        return "IP Address like \"" + this.ipLikePattern + "\"";
    }

    public String toString() {
        return "<Vulnerability IPLike Filter: " + this.getDescription() + ">";
    }

    public String getIpLikePattern() {
        return this.ipLikePattern;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

