/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.vulnerability;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletContext;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.vulnerability.Vulnerability;
import org.opennms.web.vulnerability.filter.Filter;
import org.opennms.web.vulnerability.filter.InterfaceFilter;
import org.opennms.web.vulnerability.filter.NodeFilter;

public class VulnerabilityFactory {
    protected static final ThreadCategory log = ThreadCategory.getInstance(VulnerabilityFactory.class);

    private VulnerabilityFactory() {
    }

    public static int getVulnerabilityCount() throws SQLException {
        return VulnerabilityFactory.getVulnerabilityCount(ResolutionType.OPEN, new Filter[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVulnerabilityCount(ResolutionType resType, Filter[] filters) throws SQLException {
        if (resType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int vulCount = 0;
        Connection conn = Vault.getDbConnection();
        try {
            StringBuffer select = new StringBuffer("SELECT COUNT(*) AS VULCOUNT FROM VULNERABILITIES LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) WHERE ");
            select.append(VulnerabilityFactory.getResolutionTypeClause(resType));
            for (Filter filter : filters) {
                select.append(" AND");
                select.append(filter.getParamSql());
            }
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            int parameterIndex = 1;
            for (Filter filter : filters) {
                parameterIndex += filter.bindParam(stmt, parameterIndex);
            }
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                vulCount = rs.getInt("VULCOUNT");
            }
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return vulCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vulnerability getVulnerability(int vulId) throws SQLException {
        Vulnerability vul = null;
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT VULNERABILITIES.*, NODE.NODELABEL, SERVICE.SERVICENAME FROM VULNERABILITIES LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) WHERE VULNERABILITYID=? ");
            stmt.setInt(1, vulId);
            ResultSet rs = stmt.executeQuery();
            Vulnerability[] vuls = VulnerabilityFactory.rs2Vulnerabilities(rs);
            if (vuls.length > 0) {
                vul = vuls[0];
            }
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return vul;
    }

    public static Vulnerability[] getVulnerabilitiesForNode(int nodeId, SortStyle sortStyle, ResolutionType resType, int throttle, int offset, ServletContext servletContext) throws SQLException {
        if (sortStyle == null || resType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext)};
        return VulnerabilityFactory.getVulnerabilities(sortStyle, resType, filters, throttle, offset);
    }

    public static int getVulnerabilityCountForNode(int nodeId, ResolutionType resType, ServletContext servletContext) throws SQLException {
        if (resType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext)};
        return VulnerabilityFactory.getVulnerabilityCount(resType, filters);
    }

    public static Vulnerability[] getVulnerablilitiesForInterface(int nodeId, String ipAddress, SortStyle sortStyle, ResolutionType resType, int throttle, int offset, ServletContext servletContext) throws SQLException {
        if (ipAddress == null || sortStyle == null || resType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new InterfaceFilter(ipAddress)};
        return VulnerabilityFactory.getVulnerabilities(sortStyle, resType, filters, throttle, offset);
    }

    public static int getVulnerabilityCountForInterface(int nodeId, String ipAddress, ResolutionType resType, ServletContext servletContext) throws SQLException {
        if (ipAddress == null || resType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new InterfaceFilter(ipAddress)};
        return VulnerabilityFactory.getVulnerabilityCount(resType, filters);
    }

    public static Vulnerability[] getVulnerabilities() throws SQLException {
        return VulnerabilityFactory.getVulnerabilities(SortStyle.ID, ResolutionType.OPEN);
    }

    public static Vulnerability[] getVulnerabilities(ResolutionType resType) throws SQLException {
        return VulnerabilityFactory.getVulnerabilities(SortStyle.ID, resType);
    }

    public static Vulnerability[] getVulnerabilities(SortStyle sortStyle) throws SQLException {
        return VulnerabilityFactory.getVulnerabilities(sortStyle, ResolutionType.OPEN);
    }

    public static Vulnerability[] getVulnerabilities(SortStyle sortStyle, ResolutionType resType) throws SQLException {
        return VulnerabilityFactory.getVulnerabilities(sortStyle, resType, new Filter[0]);
    }

    public static Vulnerability[] getVulnerabilities(SortStyle sortStyle, ResolutionType resType, Filter[] filters) throws SQLException {
        return VulnerabilityFactory.getVulnerabilities(sortStyle, resType, filters, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vulnerability[] getVulnerabilities(SortStyle sortStyle, ResolutionType resType, Filter[] filters, int limit, int offset) throws SQLException {
        if (sortStyle == null || resType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        boolean useLimits = false;
        if (limit > 0 && offset > -1) {
            useLimits = true;
        }
        Vulnerability[] vuls = null;
        Connection conn = Vault.getDbConnection();
        try {
            StringBuffer select = new StringBuffer("SELECT VULNERABILITIES.*, NODE.NODELABEL, SERVICE.SERVICENAME FROM VULNERABILITIES LEFT OUTER JOIN NODE USING(NODEID) LEFT OUTER JOIN SERVICE USING(SERVICEID) WHERE");
            select.append(VulnerabilityFactory.getResolutionTypeClause(resType));
            for (Filter filter : filters) {
                select.append(" AND");
                select.append(filter.getParamSql());
            }
            select.append(VulnerabilityFactory.getOrderByClause(sortStyle));
            if (useLimits) {
                select.append(" LIMIT ");
                select.append(limit);
                select.append(" OFFSET ");
                select.append(offset);
            }
            log.debug(select.toString());
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            int parameterIndex = 1;
            for (Filter filter : filters) {
                parameterIndex += filter.bindParam(stmt, parameterIndex);
            }
            ResultSet rs = stmt.executeQuery();
            vuls = VulnerabilityFactory.rs2Vulnerabilities(rs);
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return vuls;
    }

    protected static Vulnerability[] rs2Vulnerabilities(ResultSet rs) throws SQLException {
        Vulnerability[] vuls = null;
        ArrayList<Vulnerability> list = new ArrayList<Vulnerability>();
        while (rs.next()) {
            Vulnerability vul = new Vulnerability();
            Object element = new Integer(rs.getInt("vulnerabilityId"));
            vul.id = (Integer)element;
            element = rs.getObject("nodeID");
            if (element != null) {
                vul.nodeId = (Integer)element;
            }
            element = rs.getString("ipAddr");
            vul.ipAddr = (String)element;
            element = rs.getObject("serviceID");
            if (element != null) {
                vul.serviceId = (Integer)element;
            }
            element = rs.getString("nodeLabel");
            vul.nodeLabel = (String)element;
            element = rs.getString("serviceName");
            vul.serviceName = (String)element;
            element = rs.getTimestamp("creationTime");
            vul.createTime = new Date(((Timestamp)element).getTime());
            element = rs.getTimestamp("lastAttemptTime");
            vul.lastAttemptTime = new Date(((Timestamp)element).getTime());
            element = rs.getTimestamp("lastScanTime");
            vul.lastScanTime = new Date(((Timestamp)element).getTime());
            element = rs.getTimestamp("resolvedTime");
            if (element != null) {
                vul.resolvedTime = new Date(((Timestamp)element).getTime());
            }
            element = rs.getString("descr");
            vul.description = (String)element;
            element = rs.getString("logmsg");
            vul.logMessage = (String)element;
            element = new Integer(rs.getInt("severity"));
            vul.severity = OnmsSeverity.get((int)((Integer)element));
            element = new Integer(rs.getInt("pluginID"));
            vul.pluginId = (Integer)element;
            element = new Integer(rs.getInt("pluginSubID"));
            vul.pluginSubId = (Integer)element;
            element = rs.getString("descr");
            vul.description = (String)element;
            element = rs.getObject("port");
            if (element != null) {
                vul.port = (Integer)element;
            }
            element = rs.getString("protocol");
            vul.protocol = (String)element;
            element = rs.getString("cveEntry");
            vul.cveEntry = (String)element;
            list.add(vul);
        }
        vuls = list.toArray(new Vulnerability[list.size()]);
        return vuls;
    }

    protected static String getOrderByClause(SortStyle sortStyle) {
        if (sortStyle == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String clause = null;
        switch (sortStyle.getId()) {
            case 1: {
                clause = " ORDER BY VULNERABILITYID DESC";
                break;
            }
            case 101: {
                clause = " ORDER BY VULNERABILITYID ASC";
                break;
            }
            case 2: {
                clause = " ORDER BY SEVERITY DESC";
                break;
            }
            case 102: {
                clause = " ORDER BY SEVERITY ASC";
                break;
            }
            case 3: {
                clause = " ORDER BY NODELABEL ASC";
                break;
            }
            case 103: {
                clause = " ORDER BY NODELABEL DESC";
                break;
            }
            case 4: {
                clause = " ORDER BY IPADDR ASC";
                break;
            }
            case 104: {
                clause = " ORDER BY IPADDR DESC";
                break;
            }
            case 5: {
                clause = " ORDER BY SERVICENAME ASC";
                break;
            }
            case 105: {
                clause = " ORDER BY SERVICENAME DESC";
                break;
            }
            case 6: {
                clause = " ORDER BY CREATIONTIME DESC";
                break;
            }
            case 106: {
                clause = " ORDER BY CREATIONTIME ASC";
                break;
            }
            case 7: {
                clause = " ORDER BY RESOLVEDTIME DESC";
                break;
            }
            case 107: {
                clause = " ORDER BY RESOLVEDTIME ASC";
                break;
            }
            case 8: {
                clause = " ORDER BY PORT ASC";
                break;
            }
            case 108: {
                clause = " ORDER BY PORT DESC";
                break;
            }
            case 9: {
                clause = " ORDER BY PROTOCOL ASC";
                break;
            }
            case 109: {
                clause = " ORDER BY PROTOCOL DESC";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown VulnerabilityFactory.SortStyle: " + sortStyle.getName());
            }
        }
        return clause;
    }

    protected static String getResolutionTypeClause(ResolutionType resType) {
        if (resType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String clause = null;
        switch (resType.getId()) {
            case 2: {
                clause = " RESOLVEDTIME IS NOT NULL";
                break;
            }
            case 1: {
                clause = " RESOLVEDTIME IS NULL";
                break;
            }
            case 3: {
                clause = " TRUE";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown VulnerabilityFactory.ResolutionType: " + resType.getName());
            }
        }
        return clause;
    }

    public static class ResolutionType {
        public static final int _OPEN = 1;
        public static final int _RESOLVED = 2;
        public static final int _BOTH = 3;
        public static final ResolutionType OPEN = new ResolutionType("OPEN", 1);
        public static final ResolutionType RESOLVED = new ResolutionType("RESOLVED", 2);
        public static final ResolutionType BOTH = new ResolutionType("BOTH", 3);
        protected String name;
        protected int id;

        private ResolutionType(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public String toString() {
            return "Vulnerability.ResolutionType." + this.name;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }
    }

    public static class SortStyle {
        public static final int _ID = 1;
        public static final int _SEVERITY = 2;
        public static final int _NODE = 3;
        public static final int _INTERFACE = 4;
        public static final int _SERVICE = 5;
        public static final int _CREATE_TIME = 6;
        public static final int _RESOLVED_TIME = 7;
        public static final int _PORT = 8;
        public static final int _PROTOCOL = 9;
        public static final SortStyle ID = new SortStyle("ID", 1);
        public static final SortStyle SEVERITY = new SortStyle("SEVERITY", 2);
        public static final SortStyle NODE = new SortStyle("NODE", 3);
        public static final SortStyle INTERFACE = new SortStyle("INTERFACE", 4);
        public static final SortStyle SERVICE = new SortStyle("SERVICE", 5);
        public static final SortStyle CREATE_TIME = new SortStyle("CREATE_TIME", 6);
        public static final SortStyle RESOLVED_TIME = new SortStyle("RESOLVED_TIME", 7);
        public static final SortStyle PORT = new SortStyle("PORT", 8);
        public static final SortStyle PROTOCOL = new SortStyle("PROTOCOL", 9);
        public static final int _REVERSE_ID = 101;
        public static final int _REVERSE_SEVERITY = 102;
        public static final int _REVERSE_NODE = 103;
        public static final int _REVERSE_INTERFACE = 104;
        public static final int _REVERSE_SERVICE = 105;
        public static final int _REVERSE_CREATE_TIME = 106;
        public static final int _REVERSE_RESOLVED_TIME = 107;
        public static final int _REVERSE_PORT = 108;
        public static final int _REVERSE_PROTOCOL = 109;
        public static final SortStyle REVERSE_ID = new SortStyle("REVERSE_ID", 101);
        public static final SortStyle REVERSE_SEVERITY = new SortStyle("REVERSE_SEVERITY", 102);
        public static final SortStyle REVERSE_NODE = new SortStyle("REVERSE_NODE", 103);
        public static final SortStyle REVERSE_INTERFACE = new SortStyle("REVERSE_INTERFACE", 104);
        public static final SortStyle REVERSE_SERVICE = new SortStyle("REVERSE_SERVICE", 105);
        public static final SortStyle REVERSE_CREATE_TIME = new SortStyle("REVERSE_CREATE_TIME", 106);
        public static final SortStyle REVERSE_RESOLVED_TIME = new SortStyle("REVERSE_RESOLVED_TIME", 107);
        public static final SortStyle REVERSE_PORT = new SortStyle("REVERSE_PORT", 108);
        public static final SortStyle REVERSE_PROTOCOL = new SortStyle("REVERSE_PROTOCOL", 109);
        protected String name;
        protected int id;

        private SortStyle(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public String toString() {
            return "Event.SortStyle." + this.name;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }
    }
}

