/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.GraphDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.web.api.Util;
import org.opennms.web.svclayer.ResourceService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultResourceService
implements ResourceService,
InitializingBean {
    private ResourceDao m_resourceDao;
    private GraphDao m_graphDao;
    private EventProxy m_eventProxy;

    public ResourceDao getResourceDao() {
        return this.m_resourceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public GraphDao getGraphDao() {
        return this.m_graphDao;
    }

    public void setGraphDao(GraphDao graphDao) {
        this.m_graphDao = graphDao;
    }

    public void setEventProxy(EventProxy eventProxy) {
        this.m_eventProxy = eventProxy;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"resourceDao property is not set");
        Assert.state((this.m_graphDao != null ? 1 : 0) != 0, (String)"graphDao property is not set");
        Assert.state((this.m_eventProxy != null ? 1 : 0) != 0, (String)"eventProxy property is not set");
    }

    @Override
    public File getRrdDirectory() {
        return this.m_resourceDao.getRrdDirectory();
    }

    @Override
    public List<OnmsResource> findDomainResources() {
        return this.m_resourceDao.findDomainResources();
    }

    @Override
    public List<OnmsResource> findNodeResources() {
        return this.m_resourceDao.findNodeResources();
    }

    @Override
    public List<OnmsResource> findTopLevelResources() {
        return this.m_resourceDao.findTopLevelResources();
    }

    @Override
    public List<OnmsResource> findNodeChildResources(int nodeId) {
        List<Object> resources = new ArrayList<OnmsResource>();
        OnmsResource resource = this.m_resourceDao.getResourceById(OnmsResource.createResourceId((String[])new String[]{"node", Integer.toString(nodeId)}));
        if (resource != null) {
            resources = resource.getChildResources();
            resources.size();
        }
        return resources;
    }

    @Override
    public List<OnmsResource> findDomainChildResources(String domain) {
        List<Object> resources = new ArrayList<OnmsResource>();
        OnmsResource resource = this.m_resourceDao.getResourceById(OnmsResource.createResourceId((String[])new String[]{"domain", domain}));
        if (resource != null) {
            resources = resource.getChildResources();
            resources.size();
        }
        return resources;
    }

    @Override
    public List<OnmsResource> findChildResources(OnmsResource resource, String ... resourceTypeMatches) {
        LinkedList<OnmsResource> matchingChildResources = new LinkedList<OnmsResource>();
        if (resource != null) {
            for (OnmsResource childResource : resource.getChildResources()) {
                boolean addGraph = false;
                if (resourceTypeMatches.length > 0) {
                    for (String resourceTypeMatch : resourceTypeMatches) {
                        if (!resourceTypeMatch.equals(childResource.getResourceType().getName())) continue;
                        addGraph = true;
                        break;
                    }
                } else {
                    addGraph = true;
                }
                if (!addGraph) continue;
                matchingChildResources.add(DefaultResourceService.checkLabelForQuotes(childResource));
            }
        }
        return matchingChildResources;
    }

    private static OnmsResource checkLabelForQuotes(OnmsResource childResource) {
        String lbl = Util.convertToJsSafeString((String)childResource.getLabel());
        OnmsResource resource = new OnmsResource(childResource.getName(), lbl, childResource.getResourceType(), childResource.getAttributes());
        resource.setParent(childResource.getParent());
        resource.setEntity(childResource.getEntity());
        resource.setLink(childResource.getLink());
        return resource;
    }

    @Override
    public OnmsResource getResourceById(String id) {
        return this.m_resourceDao.getResourceById(id);
    }

    @Override
    public List<OnmsResource> getResourceListById(String resourceId) {
        return this.m_resourceDao.getResourceListById(resourceId);
    }

    @Override
    public PrefabGraph[] findPrefabGraphsForResource(OnmsResource resource) {
        return this.m_graphDao.getPrefabGraphsForResource(resource);
    }

    @Override
    public void promoteGraphAttributesForResource(OnmsResource resource) {
        String baseDir = this.getRrdDirectory().getAbsolutePath();
        LinkedList<String> rrdFiles = new LinkedList<String>();
        for (RrdGraphAttribute attribute : resource.getRrdGraphAttributes().values()) {
            rrdFiles.add(baseDir + File.separator + attribute.getRrdRelativePath());
        }
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/promoteQueueData", "OpenNMS.Webapp");
        bldr.addParam("filesToPromote", rrdFiles);
        try {
            this.m_eventProxy.send(bldr.getEvent());
        }
        catch (EventProxyException e) {
            DefaultResourceService.log().warn("Unable to send file promotion event to opennms: " + (Object)((Object)e), (Throwable)e);
        }
    }

    @Override
    public void promoteGraphAttributesForResource(String resourceId) {
        this.promoteGraphAttributesForResource(this.getResourceById(resourceId));
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(DefaultResourceService.class);
    }

    @Override
    public PrefabGraph[] findPrefabGraphsForChildResources(OnmsResource resource, String ... resourceTypeMatches) {
        LinkedHashMap<String, PrefabGraph> childGraphs = new LinkedHashMap<String, PrefabGraph>();
        for (OnmsResource r : this.findChildResources(resource, resourceTypeMatches)) {
            for (PrefabGraph g : this.findPrefabGraphsForResource(r)) {
                childGraphs.put(g.getName(), g);
            }
        }
        return childGraphs.values().toArray(new PrefabGraph[childGraphs.size()]);
    }

    @Override
    public PrefabGraph getPrefabGraph(String name) {
        return this.m_graphDao.getPrefabGraph(name);
    }
}

