/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.beanutils.MethodUtils;
import org.opennms.core.utils.PropertyPath;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAsset;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.web.BeanUtils;
import org.opennms.web.api.Util;
import org.opennms.web.svclayer.ManualProvisioningService;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;

public class DefaultManualProvisioningService
implements ManualProvisioningService {
    private ForeignSourceRepository m_deployedForeignSourceRepository;
    private ForeignSourceRepository m_pendingForeignSourceRepository;
    private NodeDao m_nodeDao;
    private CategoryDao m_categoryDao;
    private ServiceTypeDao m_serviceTypeDao;
    private CapsdConfig m_capsdConfig;
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeployedForeignSourceRepository(ForeignSourceRepository repository) {
        this.m_writeLock.lock();
        try {
            this.m_deployedForeignSourceRepository = repository;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPendingForeignSourceRepository(ForeignSourceRepository repository) {
        this.m_writeLock.lock();
        try {
            this.m_pendingForeignSourceRepository = repository;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeDao(NodeDao nodeDao) {
        this.m_writeLock.lock();
        try {
            this.m_nodeDao = nodeDao;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCategoryDao(CategoryDao categoryDao) {
        this.m_writeLock.lock();
        try {
            this.m_categoryDao = categoryDao;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    public void setServiceTypeDao(ServiceTypeDao serviceTypeDao) {
        this.m_serviceTypeDao = serviceTypeDao;
    }

    public void setCapsdConfig(CapsdConfig capsdConfig) {
        this.m_capsdConfig = capsdConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Requisition addCategoryToNode(String groupName, String pathToNode, String categoryName) {
        this.m_writeLock.lock();
        try {
            Requisition group = this.getProvisioningGroup(groupName);
            RequisitionNode node = BeanUtils.getPathValue(group, pathToNode, RequisitionNode.class);
            RequisitionCategory category = new RequisitionCategory();
            category.setName(categoryName);
            node.putCategory(category);
            this.m_pendingForeignSourceRepository.save(group);
            Requisition requisition = this.m_pendingForeignSourceRepository.getRequisition(groupName);
            return requisition;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Requisition addAssetFieldToNode(String groupName, String pathToNode, String assetName, String assetValue) {
        this.m_writeLock.lock();
        try {
            Requisition group = this.getProvisioningGroup(groupName);
            RequisitionNode node = BeanUtils.getPathValue(group, pathToNode, RequisitionNode.class);
            RequisitionAsset asset = new RequisitionAsset();
            asset.setName(assetName);
            asset.setValue(assetValue);
            node.putAsset(asset);
            this.m_pendingForeignSourceRepository.save(group);
            Requisition requisition = this.m_pendingForeignSourceRepository.getRequisition(groupName);
            return requisition;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Requisition addInterfaceToNode(String groupName, String pathToNode, String ipAddr) {
        this.m_writeLock.lock();
        try {
            Requisition group = this.getProvisioningGroup(groupName);
            Assert.notNull((Object)group, (String)("Group should not be Null and is null groupName: " + groupName));
            RequisitionNode node = BeanUtils.getPathValue(group, pathToNode, RequisitionNode.class);
            Assert.notNull((Object)node, (String)("Node should not be Null and pathToNode: " + pathToNode));
            PrimaryType snmpPrimary = PrimaryType.PRIMARY;
            if (node.getInterfaceCount() > 0) {
                snmpPrimary = PrimaryType.SECONDARY;
            }
            RequisitionInterface iface = this.createInterface(ipAddr, snmpPrimary);
            node.putInterface(iface);
            this.m_pendingForeignSourceRepository.save(group);
            Requisition requisition = this.m_pendingForeignSourceRepository.getRequisition(groupName);
            return requisition;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    private RequisitionInterface createInterface(String ipAddr, PrimaryType snmpPrimary) {
        RequisitionInterface iface = new RequisitionInterface();
        iface.setIpAddr(ipAddr);
        iface.setStatus(Integer.valueOf(1));
        iface.setSnmpPrimary(snmpPrimary);
        return iface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Requisition addNewNodeToGroup(String groupName, String nodeLabel) {
        this.m_writeLock.lock();
        try {
            Requisition group = this.getProvisioningGroup(groupName);
            RequisitionNode node = this.createNode(nodeLabel, String.valueOf(System.currentTimeMillis()));
            node.setBuilding(groupName);
            group.insertNode(node);
            this.m_pendingForeignSourceRepository.save(group);
            Requisition requisition = this.m_pendingForeignSourceRepository.getRequisition(groupName);
            return requisition;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    private RequisitionNode createNode(String nodeLabel, String foreignId) {
        RequisitionNode node = new RequisitionNode();
        node.setNodeLabel(nodeLabel);
        node.setForeignId(foreignId);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Requisition addServiceToInterface(String groupName, String pathToInterface, String serviceName) {
        this.m_writeLock.lock();
        try {
            Requisition group = this.getProvisioningGroup(groupName);
            RequisitionInterface iface = BeanUtils.getPathValue(group, pathToInterface, RequisitionInterface.class);
            RequisitionMonitoredService monSvc = this.createService(serviceName);
            iface.insertMonitoredService(monSvc);
            this.m_pendingForeignSourceRepository.save(group);
            Requisition requisition = this.m_pendingForeignSourceRepository.getRequisition(groupName);
            return requisition;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Requisition getProvisioningGroup(String name) {
        this.m_readLock.lock();
        try {
            Requisition deployed = this.m_deployedForeignSourceRepository.getRequisition(name);
            Requisition pending = this.m_pendingForeignSourceRepository.getRequisition(name);
            Requisition requisition = pending == null ? deployed : pending;
            return requisition;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Requisition saveProvisioningGroup(String groupName, Requisition group) {
        this.m_writeLock.lock();
        try {
            group.setForeignSource(groupName);
            this.m_pendingForeignSourceRepository.save(group);
            Requisition requisition = this.m_pendingForeignSourceRepository.getRequisition(groupName);
            return requisition;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getProvisioningGroupNames() {
        this.m_readLock.lock();
        try {
            TreeSet<String> names = new TreeSet<String>();
            for (Requisition r : this.m_deployedForeignSourceRepository.getRequisitions()) {
                names.add(r.getForeignSource());
            }
            for (Requisition r : this.m_pendingForeignSourceRepository.getRequisitions()) {
                names.add(r.getForeignSource());
            }
            TreeSet<String> treeSet = names;
            return treeSet;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Requisition createProvisioningGroup(String name) {
        this.m_writeLock.lock();
        try {
            Requisition group = new Requisition();
            group.setForeignSource(name);
            this.m_pendingForeignSourceRepository.save(group);
            Requisition requisition = this.m_pendingForeignSourceRepository.getRequisition(name);
            return requisition;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    private RequisitionMonitoredService createService(String serviceName) {
        RequisitionMonitoredService svc = new RequisitionMonitoredService();
        svc.setServiceName(serviceName);
        return svc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importProvisioningGroup(String groupName) {
        this.m_writeLock.lock();
        try {
            Requisition group = this.getProvisioningGroup(groupName);
            group.updateDateStamp();
            this.saveProvisioningGroup(groupName, group);
            EventProxy proxy = Util.createEventProxy();
            String url = this.m_pendingForeignSourceRepository.getRequisitionURL(groupName).toString();
            Assert.notNull((Object)url, (String)("Could not find url for group " + groupName + ".  Does it exists?"));
            EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/importer/reloadImport", "Web");
            bldr.addParam("url", url);
            try {
                proxy.send(bldr.getEvent());
            }
            catch (EventProxyException e) {
                throw new DataAccessResourceFailureException("Unable to send event to import group " + groupName, (Throwable)e);
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Requisition deletePath(String groupName, String pathToDelete) {
        this.m_writeLock.lock();
        try {
            Requisition group = this.getProvisioningGroup(groupName);
            PropertyPath path = new PropertyPath(pathToDelete);
            Object objToDelete = path.getValue((Object)group);
            Requisition parentObject = path.getParent() == null ? group : path.getParent().getValue((Object)group);
            String propName = path.getPropertyName();
            String methodSuffix = Character.toUpperCase(propName.charAt(0)) + propName.substring(1);
            String methodName = "delete" + methodSuffix;
            try {
                MethodUtils.invokeMethod((Object)parentObject, (String)methodName, (Object[])new Object[]{objToDelete});
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Unable to find method " + methodName + " on object of type " + parentObject.getClass(), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("unable to access property " + pathToDelete, e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("an execption occurred deleting " + pathToDelete, e);
            }
            this.m_pendingForeignSourceRepository.save(group);
            Requisition requisition = this.m_pendingForeignSourceRepository.getRequisition(groupName);
            return requisition;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Requisition> getAllGroups() {
        this.m_readLock.lock();
        try {
            LinkedList<Requisition> groups = new LinkedList<Requisition>();
            for (String groupName : this.getProvisioningGroupNames()) {
                groups.add(this.getProvisioningGroup(groupName));
            }
            LinkedList<Requisition> linkedList = groups;
            return linkedList;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteProvisioningGroup(String groupName) {
        this.m_writeLock.lock();
        try {
            Requisition r = this.getProvisioningGroup(groupName);
            if (r != null) {
                this.m_pendingForeignSourceRepository.delete(r);
                this.m_deployedForeignSourceRepository.delete(r);
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllNodes(String groupName) {
        this.m_writeLock.lock();
        try {
            Requisition group = this.m_deployedForeignSourceRepository.getRequisition(groupName);
            if (group != null) {
                group.setNodes(new ArrayList());
                this.m_deployedForeignSourceRepository.save(group);
            }
            if ((group = this.m_pendingForeignSourceRepository.getRequisition(groupName)) != null) {
                group.setNodes(new ArrayList());
                this.m_pendingForeignSourceRepository.save(group);
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getGroupDbNodeCounts() {
        this.m_readLock.lock();
        try {
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            for (String groupName : this.getProvisioningGroupNames()) {
                counts.put(groupName, this.m_nodeDao.getNodeCountForForeignSource(groupName));
            }
            HashMap<String, Integer> hashMap = counts;
            return hashMap;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getNodeCategoryNames() {
        this.m_readLock.lock();
        try {
            LinkedList<String> names = new LinkedList<String>();
            for (OnmsCategory category : this.m_categoryDao.findAll()) {
                names.add(category.getName());
            }
            LinkedList<String> linkedList = names;
            return linkedList;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getServiceTypeNames(String groupName) {
        TreeSet<String> serviceNames = new TreeSet<String>();
        this.m_readLock.lock();
        try {
            ForeignSource pendingForeignSource = this.m_pendingForeignSourceRepository.getForeignSource(groupName);
            ForeignSource deployedForeignSource = this.m_deployedForeignSourceRepository.getForeignSource(groupName);
            serviceNames.addAll(deployedForeignSource.getDetectorNames());
            serviceNames.addAll(pendingForeignSource.getDetectorNames());
            for (OnmsServiceType type : this.m_serviceTypeDao.findAll()) {
                serviceNames.add(type.getName());
            }
            serviceNames.addAll(this.m_capsdConfig.getConfiguredProtocols());
            TreeSet<String> treeSet = serviceNames;
            return treeSet;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getAssetFieldNames() {
        this.m_readLock.lock();
        try {
            Collection<String> collection = BeanUtils.getProperties(new OnmsAssetRecord());
            return collection;
        }
        finally {
            this.m_readLock.unlock();
        }
    }
}

