/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class TimeChunker {
    public static final int MINUTE = 300000;
    public static final int HOURLY = 3600000;
    public static final int DAILY = 86400000;
    private Date m_startDate;
    private Date m_endDate;
    private List<TimeChunk> m_resolutionSegments = new ArrayList<TimeChunk>();
    private Iterator<TimeChunk> m_itr;
    private int m_resolution;

    public TimeChunker(int resolution, Date startDate, Date endDate) {
        this.m_startDate = startDate;
        this.m_endDate = endDate;
        this.m_resolution = resolution;
        this.createTimeSegments(this.m_resolutionSegments, resolution, startDate.getTime(), endDate.getTime() - startDate.getTime());
    }

    private void createTimeSegments(List<TimeChunk> resolutionSegments, int resolution, long startTime, long timeInMilliseconds) {
        for (long i = 0L; i < timeInMilliseconds; i += (long)resolution) {
            Date startDate = new Date(startTime + i);
            Date endDate = new Date(startTime + i + (long)resolution);
            TimeChunk segment = new TimeChunk(startDate, endDate);
            this.m_resolutionSegments.add(segment);
        }
        this.m_itr = this.m_resolutionSegments.iterator();
    }

    public int getSegmentCount() {
        return this.m_resolutionSegments.size();
    }

    public boolean hasNext() {
        return this.m_itr.hasNext();
    }

    public TimeChunk getNextSegment() {
        return this.m_itr.next();
    }

    public TimeChunk getAt(int index) {
        return index >= this.m_resolutionSegments.size() ? null : this.m_resolutionSegments.get(index);
    }

    public int getIndexContaining(Date timestamp) {
        return (int)(timestamp.getTime() - this.m_startDate.getTime()) / this.m_resolution;
    }

    public void throwChunks() throws Chunks {
        throw new Chunks("Ewww gross you just threw chunks");
    }

    public Date getStartDate() {
        return this.m_startDate;
    }

    public Date getEndDate() {
        return this.m_endDate;
    }

    public class Chunks
    extends Exception {
        private static final long serialVersionUID = 1L;

        public Chunks(String message) {
            super(message);
        }
    }

    public class TimeChunk {
        private Date m_startDate;
        private Date m_endDate;

        public TimeChunk(Date startDate, Date endDate) {
            this.setStartDate(startDate);
            this.setEndDate(endDate);
        }

        public void setStartDate(Date startDate) {
            this.m_startDate = startDate;
        }

        public Date getStartDate() {
            return this.m_startDate;
        }

        public void setEndDate(Date endDate) {
            this.m_endDate = endDate;
        }

        public Date getEndDate() {
            return this.m_endDate;
        }

        public boolean contains(Date changeTime) {
            return !changeTime.before(this.m_startDate) && !this.m_endDate.before(changeTime);
        }
    }
}

