/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.net.URL;
import java.text.ParseException;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.ValidationException;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAsset;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAssetCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategoryCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterfaceCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredServiceCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNodeCollection;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="requisitions")
public class RequisitionRestService
extends OnmsRestService {
    @Autowired
    @Qualifier(value="pending")
    private ForeignSourceRepository m_pendingForeignSourceRepository;
    @Autowired
    @Qualifier(value="deployed")
    private ForeignSourceRepository m_deployedForeignSourceRepository;
    @Autowired
    private EventProxy m_eventProxy;
    @Context
    UriInfo m_uriInfo;
    @Context
    HttpHeaders m_headers;
    @Context
    SecurityContext m_securityContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="deployed/count")
    @Produces(value={"text/plain"})
    public String getDeployedCount() {
        this.readLock();
        try {
            String string = Integer.toString(this.m_deployedForeignSourceRepository.getRequisitions().size());
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="deployed")
    @Produces(value={"application/xml", "application/json"})
    public RequisitionCollection getDeployedRequisitions() throws ParseException {
        this.readLock();
        try {
            RequisitionCollection requisitionCollection = new RequisitionCollection((Collection)this.m_deployedForeignSourceRepository.getRequisitions());
            return requisitionCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    public RequisitionCollection getRequisitions() throws ParseException {
        this.readLock();
        try {
            TreeSet<Requisition> reqs = new TreeSet<Requisition>();
            for (String fsName : this.getActiveForeignSourceNames()) {
                Requisition r = this.getActiveRequisition(fsName);
                if (r == null) continue;
                reqs.add(r);
            }
            RequisitionCollection requisitionCollection = new RequisitionCollection(reqs);
            return requisitionCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="count")
    @Produces(value={"text/plain"})
    public String getPendingCount() {
        this.readLock();
        try {
            String string = Integer.toString(this.m_pendingForeignSourceRepository.getRequisitions().size());
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}")
    @Produces(value={"application/xml", "application/json"})
    public Requisition getRequisition(@PathParam(value="foreignSource") String foreignSource) {
        this.readLock();
        try {
            Requisition requisition = this.getActiveRequisition(foreignSource);
            return requisition;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}/exists")
    @Produces(value={"text/plain"})
    public String requisitionExists(@PathParam(value="foreignSource") String foreignSource) {
        this.readLock();
        try {
            Boolean exists = this.getActiveRequisition(foreignSource) != null;
            String string = exists.toString();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}/nodes")
    @Produces(value={"application/xml", "application/json"})
    public RequisitionNodeCollection getNodes(@PathParam(value="foreignSource") String foreignSource) throws ParseException {
        this.readLock();
        try {
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req == null) {
                RequisitionNodeCollection requisitionNodeCollection = null;
                return requisitionNodeCollection;
            }
            RequisitionNodeCollection requisitionNodeCollection = new RequisitionNodeCollection((Collection)req.getNodes());
            return requisitionNodeCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}")
    @Produces(value={"application/xml", "application/json"})
    public RequisitionNode getNode(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) throws ParseException {
        this.readLock();
        try {
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req == null) {
                RequisitionNode requisitionNode = null;
                return requisitionNode;
            }
            RequisitionNode requisitionNode = req.getNode(foreignId);
            return requisitionNode;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces")
    @Produces(value={"application/xml", "application/json"})
    public RequisitionInterfaceCollection getInterfacesForNode(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) throws ParseException {
        this.readLock();
        try {
            RequisitionNode node = this.getNode(foreignSource, foreignId);
            if (node != null) {
                RequisitionInterfaceCollection requisitionInterfaceCollection = new RequisitionInterfaceCollection((Collection)node.getInterfaces());
                return requisitionInterfaceCollection;
            }
            RequisitionInterfaceCollection requisitionInterfaceCollection = null;
            return requisitionInterfaceCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}")
    @Produces(value={"application/xml", "application/json"})
    public RequisitionInterface getInterfaceForNode(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress) throws ParseException {
        this.readLock();
        try {
            RequisitionNode node = this.getNode(foreignSource, foreignId);
            if (node != null) {
                RequisitionInterface requisitionInterface = node.getInterface(ipAddress);
                return requisitionInterface;
            }
            RequisitionInterface requisitionInterface = null;
            return requisitionInterface;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}/services")
    @Produces(value={"application/xml", "application/json"})
    public RequisitionMonitoredServiceCollection getServicesForInterface(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress) throws ParseException {
        this.readLock();
        try {
            RequisitionInterface iface = this.getInterfaceForNode(foreignSource, foreignId, ipAddress);
            if (iface != null) {
                RequisitionMonitoredServiceCollection requisitionMonitoredServiceCollection = new RequisitionMonitoredServiceCollection((Collection)iface.getMonitoredServices());
                return requisitionMonitoredServiceCollection;
            }
            RequisitionMonitoredServiceCollection requisitionMonitoredServiceCollection = null;
            return requisitionMonitoredServiceCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}/services/{service}")
    @Produces(value={"application/xml", "application/json"})
    public RequisitionMonitoredService getServiceForInterface(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String service) throws ParseException {
        this.readLock();
        try {
            RequisitionInterface iface = this.getInterfaceForNode(foreignSource, foreignId, ipAddress);
            if (iface != null) {
                RequisitionMonitoredService requisitionMonitoredService = iface.getMonitoredService(service);
                return requisitionMonitoredService;
            }
            RequisitionMonitoredService requisitionMonitoredService = null;
            return requisitionMonitoredService;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/categories")
    @Produces(value={"application/xml", "application/json"})
    public RequisitionCategoryCollection getCategories(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) throws ParseException {
        this.readLock();
        try {
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                RequisitionCategoryCollection requisitionCategoryCollection = new RequisitionCategoryCollection((Collection)node.getCategories());
                return requisitionCategoryCollection;
            }
            RequisitionCategoryCollection requisitionCategoryCollection = null;
            return requisitionCategoryCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/categories/{category}")
    @Produces(value={"application/xml", "application/json"})
    public RequisitionCategory getCategory(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="category") String category) throws ParseException {
        this.readLock();
        try {
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                RequisitionCategory requisitionCategory = node.getCategory(category);
                return requisitionCategory;
            }
            RequisitionCategory requisitionCategory = null;
            return requisitionCategory;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/assets")
    @Produces(value={"application/xml", "application/json"})
    public RequisitionAssetCollection getAssetParameters(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) throws ParseException {
        this.readLock();
        try {
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                RequisitionAssetCollection requisitionAssetCollection = new RequisitionAssetCollection((Collection)node.getAssets());
                return requisitionAssetCollection;
            }
            RequisitionAssetCollection requisitionAssetCollection = null;
            return requisitionAssetCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/assets/{parameter}")
    @Produces(value={"application/xml", "application/json"})
    public RequisitionAsset getAssetParameter(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="parameter") String parameter) throws ParseException {
        this.readLock();
        try {
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                RequisitionAsset requisitionAsset = node.getAsset(parameter);
                return requisitionAsset;
            }
            RequisitionAsset requisitionAsset = null;
            return requisitionAsset;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    @Transactional
    public Response addOrReplaceRequisition(Requisition requisition) {
        this.writeLock();
        try {
            try {
                requisition.validate();
            }
            catch (ValidationException e) {
                LogUtils.debugf((Object)this, (Throwable)e, (String)"error validating incoming requisition with foreign source '%s'", (Object[])new Object[]{requisition.getForeignSource()});
                throw this.getException(Response.Status.BAD_REQUEST, e.getMessage());
            }
            this.debug("addOrReplaceRequisition: Adding requisition %s", requisition.getForeignSource());
            this.m_pendingForeignSourceRepository.save(requisition);
            Response response = Response.ok((Object)requisition).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{foreignSource}/nodes")
    @Consumes(value={"application/xml"})
    @Transactional
    public Response addOrReplaceNode(@PathParam(value="foreignSource") String foreignSource, RequisitionNode node) {
        this.writeLock();
        try {
            this.debug("addOrReplaceNode: Adding node %s to requisition %s", node.getForeignId(), foreignSource);
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null) {
                req.putNode(node);
                this.m_pendingForeignSourceRepository.save(req);
                Response response = Response.ok((Object)req).build();
                return response;
            }
            Response response = Response.notModified().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces")
    @Consumes(value={"application/xml"})
    @Transactional
    public Response addOrReplaceInterface(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, RequisitionInterface iface) {
        this.writeLock();
        try {
            RequisitionNode node;
            this.debug("addOrReplaceInterface: Adding interface %s to node %s/%s", iface, foreignSource, foreignId);
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                node.putInterface(iface);
                this.m_pendingForeignSourceRepository.save(req);
                Response response = Response.ok((Object)req).build();
                return response;
            }
            Response response = Response.notModified().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}/services")
    @Consumes(value={"application/xml"})
    @Transactional
    public Response addOrReplaceService(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress, RequisitionMonitoredService service) {
        this.writeLock();
        try {
            RequisitionInterface iface;
            RequisitionNode node;
            this.debug("addOrReplaceService: Adding service %s to node %s/%s, interface %s", service.getServiceName(), foreignSource, foreignId, ipAddress);
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null && (node = req.getNode(foreignId)) != null && (iface = node.getInterface(ipAddress)) != null) {
                iface.putMonitoredService(service);
                this.m_pendingForeignSourceRepository.save(req);
                Response response = Response.ok((Object)req).build();
                return response;
            }
            Response response = Response.notModified().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{foreignSource}/nodes/{foreignId}/categories")
    @Consumes(value={"application/xml"})
    @Transactional
    public Response addOrReplaceNodeCategory(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, RequisitionCategory category) {
        this.writeLock();
        try {
            RequisitionNode node;
            this.debug("addOrReplaceNodeCategory: Adding category %s to node %s/%s", category.getName(), foreignSource, foreignId);
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                node.putCategory(category);
                this.m_pendingForeignSourceRepository.save(req);
                Response response = Response.ok((Object)req).build();
                return response;
            }
            Response response = Response.notModified().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{foreignSource}/nodes/{foreignId}/assets")
    @Consumes(value={"application/xml"})
    @Transactional
    public Response addOrReplaceNodeAssetParameter(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, RequisitionAsset asset) {
        this.writeLock();
        try {
            RequisitionNode node;
            this.debug("addOrReplaceNodeCategory: Adding asset %s to node %s/%s", asset.getName(), foreignSource, foreignId);
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                node.putAsset(asset);
                this.m_pendingForeignSourceRepository.save(req);
                Response response = Response.ok((Object)req).build();
                return response;
            }
            Response response = Response.notModified().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{foreignSource}/import")
    @Transactional
    public Response importRequisition(@PathParam(value="foreignSource") String foreignSource, @QueryParam(value="suppressOutput") Boolean suppressOutput, @QueryParam(value="rescanExisting") Boolean rescanExisting) {
        this.writeLock();
        try {
            this.log().debug("importing requisition for foreign source " + foreignSource);
            Requisition req = this.getActiveRequisition(foreignSource);
            String url = this.getActiveUrl(foreignSource).toString();
            EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/importer/reloadImport", "Web");
            bldr.addParam("url", url);
            if (rescanExisting != null) {
                bldr.addParam("importRescanExisting", rescanExisting.booleanValue());
            }
            try {
                this.m_eventProxy.send(bldr.getEvent());
            }
            catch (EventProxyException e) {
                throw new DataAccessResourceFailureException("Unable to send event to import group " + foreignSource, (Throwable)e);
            }
            Response response = suppressOutput == null || suppressOutput == false ? Response.ok((Object)req).build() : Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{foreignSource}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateRequisition(@PathParam(value="foreignSource") String foreignSource, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null) {
                this.debug("updateRequisition: updating requisition with foreign source %s", foreignSource);
                this.setProperties(params, req);
                this.debug("updateRequisition: requisition with foreign source %s updated", foreignSource);
                this.m_pendingForeignSourceRepository.save(req);
                Response response = Response.ok((Object)req).build();
                return response;
            }
            Response response = Response.notModified((String)foreignSource).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{foreignSource}/nodes/{foreignId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateNode(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                this.debug("updateNode: updating node with foreign source %s and foreign id %s", foreignSource, foreignId);
                this.setProperties(params, node);
                this.debug("updateNode: node with foreign source %s and foreign id %s updated", foreignSource, foreignId);
                this.m_pendingForeignSourceRepository.save(req);
                Response response = Response.ok((Object)node).build();
                return response;
            }
            Response response = Response.notModified((String)(foreignSource + "/" + foreignId)).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateInterface(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            RequisitionInterface iface;
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null && (node = req.getNode(foreignId)) != null && (iface = node.getInterface(ipAddress)) != null) {
                this.debug("updateInterface: updating interface %s on node %s/%s", ipAddress, foreignSource, foreignId);
                this.setProperties(params, iface);
                this.debug("updateInterface: interface %s on node %s/%s updated", ipAddress, foreignSource, foreignId);
                this.m_pendingForeignSourceRepository.save(req);
                Response response = Response.ok((Object)node).build();
                return response;
            }
            Response response = Response.notModified((String)(foreignSource + "/" + foreignId)).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{foreignSource}")
    @Transactional
    public Response deletePendingRequisition(@PathParam(value="foreignSource") String foreignSource) {
        this.writeLock();
        try {
            Requisition req = this.getActiveRequisition(foreignSource);
            this.debug("deletePendingRequisition: deleting pending requisition with foreign source %s", foreignSource);
            this.m_pendingForeignSourceRepository.delete(req);
            Response response = Response.ok((Object)req).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="deployed/{foreignSource}")
    @Transactional
    public Response deleteDeployedRequisition(@PathParam(value="foreignSource") String foreignSource) {
        this.writeLock();
        try {
            Requisition req = this.getActiveRequisition(foreignSource);
            this.debug("deleteDeployedRequisition: deleting pending requisition with foreign source %s", foreignSource);
            this.m_deployedForeignSourceRepository.delete(req);
            Response response = Response.ok((Object)req).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{foreignSource}/nodes/{foreignId}")
    @Transactional
    public Response deleteNode(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) {
        this.writeLock();
        try {
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null) {
                req.deleteNode(foreignId);
                this.m_pendingForeignSourceRepository.save(req);
                Response response = Response.ok((Object)req).build();
                return response;
            }
            Response response = null;
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}")
    @Transactional
    public Response deleteInterface(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress) {
        this.writeLock();
        try {
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                node.deleteInterface(ipAddress);
                this.m_pendingForeignSourceRepository.save(req);
                Response response = Response.ok((Object)req).build();
                return response;
            }
            Response response = null;
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}/services/{service}")
    @Transactional
    public Response deleteInterfaceService(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String service) {
        this.writeLock();
        try {
            RequisitionInterface iface;
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null && (node = req.getNode(foreignId)) != null && (iface = node.getInterface(ipAddress)) != null) {
                iface.deleteMonitoredService(service);
                this.m_pendingForeignSourceRepository.save(req);
                Response response = Response.ok((Object)req).build();
                return response;
            }
            Response response = null;
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{foreignSource}/nodes/{foreignId}/categories/{category}")
    @Transactional
    public Response deleteCategory(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="category") String category) {
        this.writeLock();
        try {
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                node.deleteCategory(category);
                this.m_pendingForeignSourceRepository.save(req);
                Response response = Response.ok((Object)req).build();
                return response;
            }
            Response response = null;
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{foreignSource}/nodes/{foreignId}/assets/{parameter}")
    @Transactional
    public Response deleteAssetParameter(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="parameter") String parameter) {
        this.writeLock();
        try {
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(foreignSource);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                node.deleteAsset(parameter);
                this.m_pendingForeignSourceRepository.save(req);
                Response response = Response.ok((Object)req).build();
                return response;
            }
            Response response = null;
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    private Set<String> getActiveForeignSourceNames() {
        Set fsNames = this.m_pendingForeignSourceRepository.getActiveForeignSourceNames();
        fsNames.addAll(this.m_deployedForeignSourceRepository.getActiveForeignSourceNames());
        return fsNames;
    }

    private URL getActiveUrl(String foreignSourceName) {
        Requisition pending = this.m_pendingForeignSourceRepository.getRequisition(foreignSourceName);
        Requisition deployed = this.m_deployedForeignSourceRepository.getRequisition(foreignSourceName);
        if (pending == null) {
            return this.m_deployedForeignSourceRepository.getRequisitionURL(foreignSourceName);
        }
        if (deployed == null) {
            return this.m_pendingForeignSourceRepository.getRequisitionURL(foreignSourceName);
        }
        if (deployed.getDateStamp().compare(pending.getDateStamp()) > -1) {
            return this.m_deployedForeignSourceRepository.getRequisitionURL(foreignSourceName);
        }
        return this.m_pendingForeignSourceRepository.getRequisitionURL(foreignSourceName);
    }

    private Requisition getActiveRequisition(String foreignSourceName) {
        Requisition pending = this.m_pendingForeignSourceRepository.getRequisition(foreignSourceName);
        Requisition deployed = this.m_deployedForeignSourceRepository.getRequisition(foreignSourceName);
        if (pending == null) {
            return deployed;
        }
        if (deployed == null) {
            return pending;
        }
        if (deployed.getDateStamp().compare(pending.getDateStamp()) > -1) {
            return deployed;
        }
        return pending;
    }

    private void debug(String format, Object ... values) {
    }
}

