/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.OnmsMapDao;
import org.opennms.netmgt.model.OnmsMap;
import org.opennms.netmgt.model.OnmsMapList;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsMapElementResource;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="maps")
@Transactional
public class OnmsMapRestService
extends OnmsRestService {
    @Autowired
    private OnmsMapDao m_mapDao;
    @Context
    UriInfo m_uriInfo;
    @Context
    ResourceContext m_context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsMapList getMaps() {
        this.readLock();
        try {
            CriteriaBuilder builder = new CriteriaBuilder(OnmsMap.class);
            this.applyQueryFilters((MultivaluedMap<String, String>)this.m_uriInfo.getQueryParameters(), builder);
            builder.orderBy("lastModifiedTime").desc();
            OnmsMapList onmsMapList = new OnmsMapList((Collection)this.m_mapDao.findMatching(builder.toCriteria()));
            return onmsMapList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{mapId}")
    public OnmsMap getMap(@PathParam(value="mapId") int mapId) {
        this.readLock();
        try {
            OnmsMap onmsMap = (OnmsMap)this.m_mapDao.get((Serializable)Integer.valueOf(mapId));
            return onmsMap;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    public Response addMap(OnmsMap map) {
        this.writeLock();
        try {
            LogUtils.debugf((Object)this, (String)"addMap: Adding map %s", (Object[])new Object[]{map});
            this.m_mapDao.save((Object)map);
            Response response = Response.ok((Object)map).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{mapId}")
    public Response deleteMap(@PathParam(value="mapId") int mapId) {
        this.writeLock();
        try {
            OnmsMap map = (OnmsMap)this.m_mapDao.get((Serializable)Integer.valueOf(mapId));
            if (map == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "deleteMap: Can't find map with id " + mapId);
            }
            LogUtils.debugf((Object)this, (String)"deleteMap: deleting map %d", (Object[])new Object[]{mapId});
            this.m_mapDao.delete((Object)map);
            Response response = Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{mapId}")
    public Response updateMap(@PathParam(value="mapId") int mapId, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            OnmsMap map = (OnmsMap)this.m_mapDao.get((Serializable)Integer.valueOf(mapId));
            if (map == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "updateMap: Can't find map with id " + mapId);
            }
            LogUtils.debugf((Object)this, (String)"updateMap: updating map %s", (Object[])new Object[]{map});
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)map);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
            }
            LogUtils.debugf((Object)this, (String)"updateMap: map %s updated", (Object[])new Object[]{map});
            this.m_mapDao.saveOrUpdate((Object)map);
            Response response = Response.ok((Object)map).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="{mapId}/mapElements")
    public OnmsMapElementResource getMapElementResource() {
        this.readLock();
        try {
            OnmsMapElementResource onmsMapElementResource = (OnmsMapElementResource)this.m_context.getResource(OnmsMapElementResource.class);
            return onmsMapElementResource;
        }
        finally {
            this.readUnlock();
        }
    }
}

