/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opennms.netmgt.config.TimeInterval;
import org.opennms.netmgt.config.TimeIntervalSequence;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.web.rest.support.TimeChunker;

public class AvailCalculator {
    Map<OnmsMonitoredService, ServiceAvailCalculator> m_svcCalculators = new HashMap<OnmsMonitoredService, ServiceAvailCalculator>();
    TimeChunker m_timeChunker;

    public AvailCalculator(TimeChunker timeChunker) {
        this.m_timeChunker = timeChunker;
    }

    public void onStatusChange(OnmsLocationSpecificStatus statusChange) {
        ServiceAvailCalculator calc = this.getServiceAvailCalculator(statusChange.getMonitoredService());
        calc.onStatusChange(statusChange);
    }

    private ServiceAvailCalculator getServiceAvailCalculator(OnmsMonitoredService svc) {
        ServiceAvailCalculator calc = this.m_svcCalculators.get(svc);
        if (calc == null) {
            calc = new ServiceAvailCalculator(this.m_timeChunker);
            this.m_svcCalculators.put(svc, calc);
        }
        return calc;
    }

    public double getAvailabilityFor(Collection<OnmsMonitoredService> svcs, int i) {
        double sum = 0.0;
        for (OnmsMonitoredService svc : svcs) {
            sum += this.getServiceAvailCalculator(svc).getAvailability(i);
        }
        return svcs.size() == 0 ? 1.0 : sum / (double)svcs.size();
    }

    public static class ServiceAvailCalculator {
        Map<OnmsLocationMonitor, UptimeCalculator> m_uptimeCalculators = new HashMap<OnmsLocationMonitor, UptimeCalculator>();
        TimeChunker m_timeChunker;

        public ServiceAvailCalculator(TimeChunker timeChunker) {
            this.m_timeChunker = timeChunker;
        }

        public void onStatusChange(OnmsLocationSpecificStatus statusChange) {
            UptimeCalculator calc = this.m_uptimeCalculators.get(statusChange.getLocationMonitor());
            if (calc == null) {
                calc = new UptimeCalculator(this.m_timeChunker);
                this.m_uptimeCalculators.put(statusChange.getLocationMonitor(), calc);
            }
            calc.onStatusChange(statusChange);
        }

        public double getAvailability(int i) {
            double sum = 0.0;
            for (Map.Entry<OnmsLocationMonitor, UptimeCalculator> entry : this.m_uptimeCalculators.entrySet()) {
                sum += entry.getValue().getUptimePercentage(i);
            }
            return this.m_uptimeCalculators.size() == 0 ? 1.0 : sum / (double)this.m_uptimeCalculators.size();
        }
    }

    public static class UptimeCalculator {
        public static int count = 0;
        private TimeChunker m_timeChunker;
        SortedSet<OnmsLocationSpecificStatus> m_statusChanges = new TreeSet<OnmsLocationSpecificStatus>(new Comparator<OnmsLocationSpecificStatus>(){

            @Override
            public int compare(OnmsLocationSpecificStatus o1, OnmsLocationSpecificStatus o2) {
                return o1.getPollResult().getTimestamp().compareTo(o2.getPollResult().getTimestamp());
            }
        });

        public UptimeCalculator(TimeChunker timeChunker) {
            this.m_timeChunker = timeChunker;
        }

        public Date timestamp(OnmsLocationSpecificStatus status) {
            return new Date(status.getPollResult().getTimestamp().getTime());
        }

        public void onStatusChange(OnmsLocationSpecificStatus statusChange) {
            this.m_statusChanges.add(statusChange);
        }

        public double getUptimePercentage(int index) {
            Date end;
            Date start;
            TimeChunker.TimeChunk chunk = this.m_timeChunker.getAt(index);
            TimeIntervalSequence uptime = new TimeIntervalSequence(new TimeInterval(chunk.getStartDate(), chunk.getEndDate()));
            OnmsLocationSpecificStatus lastChange = null;
            for (OnmsLocationSpecificStatus status : this.m_statusChanges) {
                ++count;
                Date start2 = lastChange == null ? new Date(0L) : new Date(lastChange.getPollResult().getTimestamp().getTime());
                Date end2 = new Date(status.getPollResult().getTimestamp().getTime());
                if (lastChange != null && lastChange.getPollResult().isDown() && start2.before(end2)) {
                    uptime.removeInterval(new TimeInterval(start2, end2));
                }
                lastChange = status;
            }
            if (lastChange != null && lastChange.getPollResult().isDown() && (start = new Date(lastChange.getPollResult().getTimestamp().getTime())).before(end = new Date(chunk.getEndDate().getTime()))) {
                uptime.removeInterval(new TimeInterval(start, end));
            }
            return this.uptime(chunk, uptime);
        }

        private double uptime(TimeChunker.TimeChunk chunk, TimeIntervalSequence uptime) {
            TimeIntervalSequence sequence = uptime;
            long uptimeMillis = 0L;
            for (TimeInterval interval : sequence) {
                uptimeMillis += interval.getEnd().getTime() - interval.getStart().getTime();
            }
            long totalMillis = chunk.getEndDate().getTime() - chunk.getStartDate().getTime();
            return (double)uptimeMillis / (double)totalMillis;
        }
    }
}

