/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsAlarmCollection;
import org.opennms.web.rest.AlarmRestServiceBase;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="alarms")
public class AlarmRestService
extends AlarmRestServiceBase {
    @Autowired
    private AlarmDao m_alarmDao;
    @Context
    UriInfo m_uriInfo;
    @Context
    SecurityContext m_securityContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{alarmId}")
    @Transactional
    public OnmsAlarm getAlarm(@PathParam(value="alarmId") String alarmId) {
        this.readLock();
        try {
            OnmsAlarm onmsAlarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)new Integer(alarmId));
            return onmsAlarm;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        this.readLock();
        try {
            String string = Integer.toString(this.m_alarmDao.countAll());
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    public OnmsAlarmCollection getAlarms() {
        this.readLock();
        try {
            CriteriaBuilder builder = this.getCriteriaBuilder((MultivaluedMap<String, String>)this.m_uriInfo.getQueryParameters(), false);
            builder.distinct();
            OnmsAlarmCollection coll = new OnmsAlarmCollection((Collection)this.m_alarmDao.findMatching(builder.toCriteria()));
            coll.setTotalCount(this.m_alarmDao.countMatching(builder.clearOrder().limit(Integer.valueOf(0)).offset(Integer.valueOf(0)).toCriteria()));
            OnmsAlarmCollection onmsAlarmCollection = coll;
            return onmsAlarmCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{alarmId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public void updateAlarm(@PathParam(value="alarmId") String alarmId, @FormParam(value="ack") Boolean ack) {
        this.writeLock();
        try {
            OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)new Integer(alarmId));
            if (ack == null) {
                throw new IllegalArgumentException("Must supply the 'ack' parameter, set to either 'true' or 'false'");
            }
            this.processAlarmAck(alarm, ack);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Transactional
    @Consumes(value={"application/x-www-form-urlencoded"})
    public void updateAlarms(MultivaluedMapImpl formProperties) {
        this.writeLock();
        try {
            Boolean ack = false;
            if (formProperties.containsKey("ack")) {
                ack = "true".equals(formProperties.getFirst("ack"));
                formProperties.remove("ack");
            }
            CriteriaBuilder builder = this.getCriteriaBuilder(formProperties, false);
            builder.distinct();
            builder.limit(Integer.valueOf(0));
            builder.offset(Integer.valueOf(0));
            for (OnmsAlarm alarm : this.m_alarmDao.findMatching(builder.toCriteria())) {
                this.processAlarmAck(alarm, ack);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private void processAlarmAck(OnmsAlarm alarm, Boolean ack) {
        if (ack.booleanValue()) {
            alarm.setAlarmAckTime(new Date());
            alarm.setAlarmAckUser(this.m_securityContext.getUserPrincipal().getName());
        } else {
            alarm.setAlarmAckTime(null);
            alarm.setAlarmAckUser(null);
        }
        this.m_alarmDao.save((Object)alarm);
    }
}

