/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.opennms.netmgt.model.outage.OutageSummary;
import org.opennms.web.filter.Filter;
import org.opennms.web.outage.Outage;
import org.opennms.web.outage.OutageType;
import org.opennms.web.outage.SortStyle;
import org.opennms.web.outage.WebOutageRepository;
import org.opennms.web.outage.filter.OutageCriteria;
import org.opennms.web.outage.filter.OutageIdFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class JdbcWebOutageRepository
implements WebOutageRepository {
    @Autowired
    SimpleJdbcTemplate m_simpleJdbcTemplate;

    @Override
    public int countCurrentOutages() {
        return this.getCurrentOutages(0).length;
    }

    @Override
    public OutageSummary[] getCurrentOutages(int rows) {
        return this.getMatchingOutageSummaries(new OutageCriteria(new Filter[0], SortStyle.IFLOSTSERVICE, OutageType.CURRENT, rows, 0));
    }

    @Override
    public int countMatchingOutages(OutageCriteria criteria) {
        String sql = this.getSql("SELECT COUNT(OUTAGEID) as OUTAGECOUNT FROM OUTAGES LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) JOIN IPINTERFACE ON OUTAGES.NODEID=IPINTERFACE.NODEID AND OUTAGES.IPADDR=IPINTERFACE.IPADDR JOIN IFSERVICES ON OUTAGES.NODEID=IFSERVICES.NODEID AND OUTAGES.IPADDR=IFSERVICES.IPADDR AND OUTAGES.SERVICEID=IFSERVICES.SERVICEID ", null, criteria);
        return this.queryForInt(sql, this.paramSetter(criteria, new Object[0]));
    }

    @Override
    public Outage[] getMatchingOutages(OutageCriteria criteria) {
        String sql = this.getSql("SELECT OUTAGES.*, NODE.NODELABEL, IPINTERFACE.IPHOSTNAME, SERVICE.SERVICENAME, NOTIFICATIONS.NOTIFYID, NOTIFICATIONS.ANSWEREDBY FROM OUTAGES JOIN NODE USING(NODEID) JOIN IPINTERFACE ON OUTAGES.NODEID=IPINTERFACE.NODEID AND OUTAGES.IPADDR=IPINTERFACE.IPADDR JOIN IFSERVICES ON OUTAGES.NODEID=IFSERVICES.NODEID AND OUTAGES.IPADDR=IFSERVICES.IPADDR AND OUTAGES.SERVICEID=IFSERVICES.SERVICEID LEFT OUTER JOIN SERVICE ON OUTAGES.SERVICEID=SERVICE.SERVICEID LEFT OUTER JOIN NOTIFICATIONS ON SVCLOSTEVENTID=NOTIFICATIONS.EVENTID LEFT OUTER JOIN ASSETS ON NODE.NODEID=ASSETS.NODEID ", null, criteria);
        return this.getOutages(sql, this.paramSetter(criteria, new Object[0]));
    }

    @Override
    public int countMatchingOutageSummaries(OutageCriteria criteria) {
        String sql = this.getSql("SELECT COUNT(DISTINCT NODE.NODEID) AS OUTAGECOUNT FROM OUTAGES LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) JOIN IPINTERFACE ON OUTAGES.NODEID=IPINTERFACE.NODEID AND OUTAGES.IPADDR=IPINTERFACE.IPADDR JOIN IFSERVICES ON OUTAGES.NODEID=IFSERVICES.NODEID AND OUTAGES.IPADDR=IFSERVICES.IPADDR AND OUTAGES.SERVICEID=IFSERVICES.SERVICEID ", null, criteria);
        return this.queryForInt(sql, this.paramSetter(criteria, new Object[0]));
    }

    @Override
    public OutageSummary[] getMatchingOutageSummaries(OutageCriteria criteria) {
        String sql = this.getSql("SELECT DISTINCT NODE.NODEID, NODE.NODELABEL, max(OUTAGES.IFLOSTSERVICE) AS IFLOSTSERVICE, max(OUTAGES.IFREGAINEDSERVICE) AS IFREGAINEDSERVICE, NOW() AS CURRENTTIME FROM OUTAGES LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) JOIN IPINTERFACE ON OUTAGES.NODEID=IPINTERFACE.NODEID AND OUTAGES.IPADDR=IPINTERFACE.IPADDR JOIN IFSERVICES ON OUTAGES.NODEID=IFSERVICES.NODEID AND OUTAGES.IPADDR=IFSERVICES.IPADDR AND OUTAGES.SERVICEID=IFSERVICES.SERVICEID ", "NODE.NODEID, NODE.NODELABEL", criteria);
        return this.getOutageSummaries(sql, this.paramSetter(criteria, new Object[0]));
    }

    @Override
    public Outage getOutage(int outageId) {
        OutageCriteria criteria = new OutageCriteria(new OutageIdFilter(outageId));
        Outage[] outages = this.getMatchingOutages(criteria);
        if (outages.length == 0) {
            return null;
        }
        return outages[0];
    }

    private OutageSummary[] getOutageSummaries(String sql, PreparedStatementSetter setter) {
        List<OutageSummary> summaries = this.queryForList(sql, setter, new OutageSummaryMapper());
        return summaries.toArray(new OutageSummary[0]);
    }

    private Outage[] getOutages(String sql, PreparedStatementSetter setter) {
        List<Outage> outages = this.queryForList(sql, setter, new OutageMapper());
        return outages.toArray(new Outage[0]);
    }

    private String getSql(String selectClause, final String groupByClause, OutageCriteria criteria) {
        final StringBuilder buf = new StringBuilder(selectClause);
        criteria.visit(new OutageCriteria.OutageCriteriaVisitor<RuntimeException>(){
            boolean first = true;

            public void and(StringBuilder buf2) {
                if (this.first) {
                    buf2.append(" WHERE (NODE.NODETYPE IS NULL OR NODE.NODETYPE != 'D') AND (IPINTERFACE.ISMANAGED IS NULL OR IPINTERFACE.ISMANAGED != 'D') AND (IFSERVICES.STATUS IS NULL OR IFSERVICES.STATUS != 'D') AND ");
                    this.first = false;
                } else {
                    buf2.append(" AND ");
                }
            }

            @Override
            public void visitOutageType(OutageType outageType) {
                this.and(buf);
                buf.append(outageType.getClause());
            }

            @Override
            public void visitFilter(Filter filter) {
                this.and(buf);
                buf.append(filter.getParamSql());
            }

            @Override
            public void visitGroupBy() {
                if (groupByClause != null && groupByClause.trim().length() != 0) {
                    buf.append(" GROUP BY ");
                    buf.append(groupByClause);
                }
            }

            @Override
            public void visitSortStyle(SortStyle sortStyle) {
                buf.append(" ");
                buf.append(sortStyle.getOrderByClause());
            }

            @Override
            public void visitLimit(int limit, int offset) {
                buf.append(" LIMIT ").append(limit).append(" OFFSET ").append(offset);
            }
        });
        return buf.toString();
    }

    private int queryForInt(String sql, PreparedStatementSetter setter) throws DataAccessException {
        Integer number = (Integer)this.queryForObject(sql, setter, (RowMapper)new SingleColumnRowMapper(Integer.class));
        return number != null ? number : 0;
    }

    private <T> T queryForObject(String sql, PreparedStatementSetter setter, RowMapper<T> rowMapper) throws DataAccessException {
        return (T)DataAccessUtils.requiredSingleResult((Collection)((Collection)this.jdbc().query(sql, setter, (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper, 1))));
    }

    private <T> List<T> queryForList(String sql, PreparedStatementSetter setter, ParameterizedRowMapper<T> rm) {
        return (List)this.jdbc().query(sql, setter, (ResultSetExtractor)new RowMapperResultSetExtractor(rm));
    }

    private JdbcOperations jdbc() {
        return this.m_simpleJdbcTemplate.getJdbcOperations();
    }

    private PreparedStatementSetter paramSetter(final OutageCriteria criteria, final Object ... args) {
        return new PreparedStatementSetter(){
            int paramIndex = 1;

            public void setValues(final PreparedStatement ps) throws SQLException {
                for (Object arg : args) {
                    ps.setObject(this.paramIndex, arg);
                    ++this.paramIndex;
                }
                criteria.visit(new OutageCriteria.BaseOutageCriteriaVisitor<SQLException>(){

                    @Override
                    public void visitFilter(Filter filter) throws SQLException {
                        paramIndex += filter.bindParam(ps, paramIndex);
                    }
                });
            }
        };
    }

    private static Date getTimestamp(String field, ResultSet rs) throws SQLException {
        if (rs.getTimestamp(field) != null) {
            return new Date(rs.getTimestamp(field).getTime());
        }
        return null;
    }

    private static class OutageMapper
    implements ParameterizedRowMapper<Outage> {
        private OutageMapper() {
        }

        public Outage mapRow(ResultSet rs, int rowNum) throws SQLException {
            Outage outage = new Outage();
            outage.outageId = (Integer)rs.getObject("outageID");
            outage.lostServiceEventId = (Integer)rs.getObject("svcLostEventID");
            outage.regainedServiceEventId = (Integer)rs.getObject("svcRegainedEventID");
            outage.nodeId = (Integer)rs.getObject("nodeID");
            outage.ipAddress = (String)rs.getObject("ipAddr");
            outage.serviceId = (Integer)rs.getObject("serviceID");
            outage.lostServiceTime = JdbcWebOutageRepository.getTimestamp("ifLostService", rs);
            outage.regainedServiceTime = JdbcWebOutageRepository.getTimestamp("ifRegainedService", rs);
            outage.suppressTime = JdbcWebOutageRepository.getTimestamp("suppressTime", rs);
            outage.suppressedBy = (String)rs.getObject("suppressedBy");
            outage.hostname = (String)rs.getObject("ipHostname");
            outage.lostServiceNotificationAcknowledgedBy = (String)rs.getObject("answeredBy");
            outage.lostServiceNotificationId = (Integer)rs.getObject("notifyId");
            outage.nodeLabel = (String)rs.getObject("nodeLabel");
            outage.serviceName = (String)rs.getObject("serviceName");
            return outage;
        }
    }

    private static class OutageSummaryMapper
    implements ParameterizedRowMapper<OutageSummary> {
        private OutageSummaryMapper() {
        }

        public OutageSummary mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new OutageSummary(rs.getInt("nodeID"), rs.getString("nodeLabel"), JdbcWebOutageRepository.getTimestamp("ifLostService", rs), JdbcWebOutageRepository.getTimestamp("ifRegainedService", rs), JdbcWebOutageRepository.getTimestamp("currentTime", rs));
        }
    }
}

