/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.map.ResponseAssembler;
import org.opennms.web.map.view.Manager;
import org.opennms.web.map.view.VElement;
import org.opennms.web.map.view.VMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class SearchMapsController
implements Controller {
    ThreadCategory log;
    private Manager manager;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ThreadCategory.setPrefix((String)"OpenNMS.Map");
        this.log = ThreadCategory.getInstance(this.getClass());
        int mapWidth = WebSecurityUtils.safeParseInt((String)request.getParameter("MapWidth"));
        int mapHeight = WebSecurityUtils.safeParseInt((String)request.getParameter("MapHeight"));
        this.log.debug("Current mapWidth=" + mapWidth + " and MapHeight=" + mapHeight);
        int d = WebSecurityUtils.safeParseInt((String)request.getParameter("MapElemDimension"));
        this.log.debug("default element dimension: " + d);
        String elems = request.getParameter("elems");
        this.log.debug("Adding Searching Maps: elems=" + elems);
        int n = mapWidth / 4 / d;
        int k = mapHeight / 2 / d;
        this.log.debug("Max number of element on the row: " + n);
        this.log.debug("Max number of element in the map: " + n * k);
        String[] smapids = elems.split(",");
        this.log.debug("Map Element to add to the Search Map: " + smapids.length);
        while (smapids.length > n * k) {
            this.log.info("the map dimension is too big: resizing");
            this.log.info("new element dimension: " + (d -= 5));
            n = mapWidth / 4 / d;
            k = mapHeight / 2 / d;
            this.log.debug("Recalculated - Max number of element on the row: " + n);
            this.log.debug("Recalculated - Max number of element in the map: " + n * k);
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
        try {
            ArrayList<VElement> velems = new ArrayList<VElement>();
            int x = -1;
            int y = 0;
            int s = 1;
            for (int i = 0; i < smapids.length; ++i) {
                if (x < n) {
                    ++x;
                } else {
                    ++y;
                    if (s == 1) {
                        x = 1;
                        --s;
                    } else {
                        x = 0;
                        ++s;
                    }
                }
                velems.add(this.manager.newElement(-3, new Integer(smapids[i]), "M", null, x * 4 * d + s * 2 * d, y * 2 * d + d));
            }
            VMap map = this.manager.searchMap(request.getRemoteUser(), request.getRemoteUser(), mapWidth, mapHeight, velems);
            this.log.debug("Got search map from manager " + map);
            bw.write(ResponseAssembler.getMapResponse(map));
        }
        catch (Throwable e) {
            this.log.error("Error while adding Maps: ", e);
            bw.write(ResponseAssembler.getMapErrorResponse("SearchMap"));
        }
        finally {
            bw.close();
        }
        return null;
    }
}

