/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.map.ResponseAssembler;
import org.opennms.web.map.view.Manager;
import org.opennms.web.map.view.VElement;
import org.opennms.web.map.view.VMap;
import org.opennms.web.map.view.VMapInfo;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class OpenMapController
implements Controller {
    ThreadCategory log;
    private Manager manager;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ThreadCategory.setPrefix((String)"OpenNMS.Map");
        this.log = ThreadCategory.getInstance(this.getClass());
        this.log.debug(request.getQueryString());
        String mapIdStr = request.getParameter("MapId");
        this.log.debug("MapId=" + mapIdStr);
        String mapWidthStr = request.getParameter("MapWidth");
        this.log.debug("MapWidth=" + mapWidthStr);
        String mapHeightStr = request.getParameter("MapHeight");
        this.log.debug("MapHeight=" + mapHeightStr);
        String adminModeStr = request.getParameter("adminMode");
        this.log.debug("adminMode=" + adminModeStr);
        String user = request.getRemoteUser();
        if (request.isUserInRole("ROLE_ADMIN")) {
            this.log.info(user + " has Admin admin Role");
        }
        float widthFactor = 1.0f;
        float heightFactor = 1.0f;
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
        try {
            int mapWidth = WebSecurityUtils.safeParseInt((String)mapWidthStr);
            int mapHeight = WebSecurityUtils.safeParseInt((String)mapHeightStr);
            this.log.debug("Current mapWidth=" + mapWidth + " and MapHeight=" + mapHeight);
            VMap map = null;
            if (mapIdStr != null) {
                int mapid = WebSecurityUtils.safeParseInt((String)mapIdStr);
                this.log.debug("Opening map " + mapid + " for user " + user);
                map = this.manager.openMap(mapid, user, !adminModeStr.equals("true"));
            } else {
                this.log.debug("Try to Opening default map");
                VMapInfo defaultmapinfo = this.manager.getDefaultMapsMenu(user);
                map = defaultmapinfo != null ? this.manager.openMap(defaultmapinfo.getId(), user, !adminModeStr.equals("true")) : this.manager.openMap();
            }
            if (map != null) {
                int dbMapWidth = map.getWidth();
                int dbMapHeight = map.getHeight();
                widthFactor = (float)mapWidth / (float)dbMapWidth;
                heightFactor = (float)mapHeight / (float)dbMapHeight;
                this.log.debug("Old saved mapWidth=" + dbMapWidth + " and MapHeight=" + dbMapHeight);
                this.log.debug("widthFactor=" + widthFactor);
                this.log.debug("heightFactor=" + heightFactor);
                this.log.debug("Setting new width and height to the session map");
                map.setHeight(mapHeight);
                map.setWidth(mapWidth);
                for (VElement ve : map.getElements().values()) {
                    ve.setX((int)((float)ve.getX() * widthFactor));
                    ve.setY((int)((float)ve.getY() * heightFactor));
                }
            }
            bw.write(ResponseAssembler.getMapResponse(map));
        }
        catch (Throwable e) {
            this.log.error("Error while opening map with id:" + mapIdStr + ", for user:" + user, e);
            bw.write(ResponseAssembler.getMapErrorResponse("OpenMap"));
        }
        finally {
            bw.close();
        }
        return null;
    }
}

