/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opennms.netmgt.config.GroupDao;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.web.group.WebGroup;
import org.opennms.web.group.WebGroupRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DefaultWebGroupRepository
implements WebGroupRepository {
    @Autowired
    private GroupDao m_groupDao;
    @Autowired
    private CategoryDao m_categoryDao;

    @Override
    @Transactional
    public boolean groupExists(String groupName) {
        return this.m_groupDao.hasGroup(groupName);
    }

    @Override
    @Transactional
    public WebGroup getGroup(String groupName) {
        Group group = this.m_groupDao.getGroup(groupName);
        WebGroup webGroup = new WebGroup(group, this.getAuthorizedCategories(groupName));
        return webGroup;
    }

    @Override
    @Transactional
    public void saveGroup(WebGroup webGroup) {
        Group group = this.m_groupDao.getGroup(webGroup.getName());
        if (group == null) {
            group = new Group();
            group.setName(webGroup.getName());
        }
        group.setComments(webGroup.getComments());
        group.setDutySchedule(webGroup.getDutySchedules());
        group.setUser(webGroup.getUsers());
        if (!webGroup.getDefaultMap().equals("")) {
            group.setDefaultMap(webGroup.getDefaultMap());
        }
        this.setAuthorizedCategories(webGroup.getName(), webGroup.getAuthorizedCategories());
        this.m_groupDao.saveGroup(group.getName(), group);
    }

    @Override
    @Transactional
    public void deleteGroup(String groupName) {
        this.m_groupDao.deleteGroup(groupName);
        this.setAuthorizedCategories(groupName, Collections.<String>emptyList());
    }

    @Override
    @Transactional
    public void renameGroup(String oldName, String newName) {
        this.m_groupDao.renameGroup(oldName, newName);
        List<String> categories = this.getAuthorizedCategories(oldName);
        this.setAuthorizedCategories(oldName, Collections.<String>emptyList());
        this.setAuthorizedCategories(newName, categories);
    }

    private List<String> getAuthorizedCategories(String groupName) {
        List categories = this.m_categoryDao.getCategoriesWithAuthorizedGroup(groupName);
        ArrayList<String> categoryNames = new ArrayList<String>(categories.size());
        for (OnmsCategory category : categories) {
            categoryNames.add(category.getName());
        }
        return categoryNames;
    }

    private void setAuthorizedCategories(String groupName, List<String> categoryNames) {
        List categories = this.m_categoryDao.getCategoriesWithAuthorizedGroup(groupName);
        for (OnmsCategory category : categories) {
            category.getAuthorizedGroups().remove(groupName);
        }
        for (String categoryName : categoryNames) {
            OnmsCategory category = this.m_categoryDao.findByName(categoryName, false);
            if (category == null) continue;
            category.getAuthorizedGroups().add(groupName);
        }
    }
}

