/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.MissingParameterException;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.api.Util;
import org.opennms.web.event.EventUtil;
import org.opennms.web.event.filter.AfterDateFilter;
import org.opennms.web.event.filter.BeforeDateFilter;
import org.opennms.web.event.filter.IPAddrLikeFilter;
import org.opennms.web.event.filter.LogMessageMatchesAnyFilter;
import org.opennms.web.event.filter.LogMessageSubstringFilter;
import org.opennms.web.event.filter.NodeNameLikeFilter;
import org.opennms.web.event.filter.ServiceFilter;
import org.opennms.web.event.filter.SeverityFilter;
import org.opennms.web.filter.Filter;

public class EventQueryServlet
extends HttpServlet {
    private static final long serialVersionUID = 1226547298266948865L;
    protected static String[] IGNORE_LIST = new String[]{"msgsub", "msgmatchany", "nodenamelike", "service", "iplike", "severity", "relativetime", "usebeforetime", "beforehour", "beforeminute", "beforeampm", "beforedate", "beforemonth", "beforeyear", "useaftertime", "afterhour", "afterminute", "afterampm", "afterdate", "aftermonth", "afteryear"};
    protected String redirectUrl = "filter";

    public void init() throws ServletException {
        ServletConfig config = this.getServletConfig();
        if (config.getInitParameter("redirect.url") != null) {
            this.redirectUrl = config.getInitParameter("redirect.url");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String useAfterTime;
        String useBeforeTime;
        String relativeTime;
        String severity;
        String ipLikePattern;
        String service;
        String nodeNameLike;
        String msgMatchAny;
        ArrayList<Filter> filterArray = new ArrayList<Filter>();
        String msgSubstring = WebSecurityUtils.sanitizeString((String)request.getParameter("msgsub"));
        if (msgSubstring != null && msgSubstring.length() > 0) {
            filterArray.add(new LogMessageSubstringFilter(msgSubstring));
        }
        if ((msgMatchAny = WebSecurityUtils.sanitizeString((String)request.getParameter("msgmatchany"))) != null && msgMatchAny.length() > 0) {
            filterArray.add(new LogMessageMatchesAnyFilter(msgMatchAny));
        }
        if ((nodeNameLike = WebSecurityUtils.sanitizeString((String)request.getParameter("nodenamelike"))) != null && nodeNameLike.length() > 0) {
            filterArray.add(new NodeNameLikeFilter(nodeNameLike));
        }
        if ((service = WebSecurityUtils.sanitizeString((String)request.getParameter("service"))) != null && !service.equalsIgnoreCase("any")) {
            filterArray.add(new ServiceFilter(WebSecurityUtils.safeParseInt((String)service), this.getServletContext()));
        }
        if ((ipLikePattern = WebSecurityUtils.sanitizeString((String)request.getParameter("iplike"))) != null && !ipLikePattern.equals("")) {
            filterArray.add(new IPAddrLikeFilter(ipLikePattern));
        }
        if ((severity = WebSecurityUtils.sanitizeString((String)request.getParameter("severity"))) != null && !severity.equalsIgnoreCase("any")) {
            filterArray.add(new SeverityFilter(WebSecurityUtils.safeParseInt((String)severity)));
        }
        if ((relativeTime = WebSecurityUtils.sanitizeString((String)request.getParameter("relativetime"))) != null && !relativeTime.equalsIgnoreCase("any")) {
            try {
                filterArray.add(EventUtil.getRelativeTimeFilter(WebSecurityUtils.safeParseInt((String)relativeTime)));
            }
            catch (IllegalArgumentException e) {
                this.log("Illegal relativetime value", e);
            }
        }
        if ((useBeforeTime = WebSecurityUtils.sanitizeString((String)request.getParameter("usebeforetime"))) != null && useBeforeTime.equals("1")) {
            try {
                filterArray.add(this.getBeforeDateFilter(request));
            }
            catch (IllegalArgumentException e) {
                this.log("Illegal before time value", e);
            }
            catch (MissingParameterException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if ((useAfterTime = WebSecurityUtils.sanitizeString((String)request.getParameter("useaftertime"))) != null && useAfterTime.equals("1")) {
            try {
                filterArray.add(this.getAfterDateFilter(request));
            }
            catch (IllegalArgumentException e) {
                this.log("Illegal after time value", e);
            }
            catch (MissingParameterException e) {
                throw new ServletException((Throwable)e);
            }
        }
        String queryString = "";
        if (filterArray.size() > 0) {
            String[] filterStrings = new String[filterArray.size()];
            for (int i = 0; i < filterStrings.length; ++i) {
                Filter filter = (Filter)filterArray.get(i);
                filterStrings[i] = EventUtil.getFilterString(filter);
            }
            HashMap<String, String[]> paramAdditions = new HashMap<String, String[]>();
            paramAdditions.put("filter", filterStrings);
            queryString = WebSecurityUtils.sanitizeString((String)Util.makeQueryString((HttpServletRequest)request, paramAdditions, (String[])IGNORE_LIST));
        } else {
            queryString = WebSecurityUtils.sanitizeString((String)Util.makeQueryString((HttpServletRequest)request, (String[])IGNORE_LIST));
        }
        response.sendRedirect(this.redirectUrl + "?" + queryString);
    }

    protected BeforeDateFilter getBeforeDateFilter(HttpServletRequest request) {
        Date beforeDate = this.getDateFromRequest(request, "before");
        return new BeforeDateFilter(beforeDate);
    }

    protected AfterDateFilter getAfterDateFilter(HttpServletRequest request) {
        Date afterDate = this.getDateFromRequest(request, "after");
        return new AfterDateFilter(afterDate);
    }

    protected Date getDateFromRequest(HttpServletRequest request, String prefix) throws MissingParameterException {
        if (request == null || prefix == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Calendar cal = Calendar.getInstance();
        cal.setLenient(true);
        String hourString = WebSecurityUtils.sanitizeString((String)request.getParameter(prefix + "hour"));
        if (hourString == null) {
            throw new MissingParameterException(prefix + "hour", this.getRequiredDateFields(prefix));
        }
        cal.set(10, WebSecurityUtils.safeParseInt((String)hourString));
        String minuteString = WebSecurityUtils.sanitizeString((String)request.getParameter(prefix + "minute"));
        if (minuteString == null) {
            throw new MissingParameterException(prefix + "minute", this.getRequiredDateFields(prefix));
        }
        cal.set(12, WebSecurityUtils.safeParseInt((String)minuteString));
        String amPmString = WebSecurityUtils.sanitizeString((String)request.getParameter(prefix + "ampm"));
        if (amPmString == null) {
            throw new MissingParameterException(prefix + "ampm", this.getRequiredDateFields(prefix));
        }
        if (amPmString.equalsIgnoreCase("am")) {
            cal.set(9, 0);
        } else if (amPmString.equalsIgnoreCase("pm")) {
            cal.set(9, 1);
        } else {
            throw new IllegalArgumentException("Illegal AM/PM value: " + amPmString);
        }
        String monthString = WebSecurityUtils.sanitizeString((String)request.getParameter(prefix + "month"));
        if (monthString == null) {
            throw new MissingParameterException(prefix + "month", this.getRequiredDateFields(prefix));
        }
        cal.set(2, WebSecurityUtils.safeParseInt((String)monthString));
        String dateString = WebSecurityUtils.sanitizeString((String)request.getParameter(prefix + "date"));
        if (dateString == null) {
            throw new MissingParameterException(prefix + "date", this.getRequiredDateFields(prefix));
        }
        cal.set(5, WebSecurityUtils.safeParseInt((String)dateString));
        String yearString = WebSecurityUtils.sanitizeString((String)request.getParameter(prefix + "year"));
        if (yearString == null) {
            throw new MissingParameterException(prefix + "year", this.getRequiredDateFields(prefix));
        }
        cal.set(1, WebSecurityUtils.safeParseInt((String)yearString));
        return cal.getTime();
    }

    protected String[] getRequiredDateFields(String prefix) {
        return new String[]{prefix + "hour", prefix + "minute", prefix + "ampm", prefix + "date", prefix + "month", prefix + "year"};
    }
}

