/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.web.MissingParameterException;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.element.Service;
import org.opennms.web.element.SnmpIfAdmin;

public final class ManageSnmpIntfServlet
extends HttpServlet {
    private static final long serialVersionUID = 996461881276250543L;
    protected int snmpServiceId;
    protected SnmpPeerFactory snmpPeerFactory;
    protected String pageToRedirect;

    public void init() throws ServletException {
        try {
            this.snmpServiceId = NetworkElementFactory.getInstance(this.getServletContext()).getServiceIdFromName("SNMP");
            SnmpPeerFactory.init();
        }
        catch (Throwable e) {
            throw new ServletException("Could not determine the SNMP service ID", e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ThreadCategory log = ThreadCategory.getInstance();
        HttpSession userSession = request.getSession(false);
        if (userSession == null) {
            throw new ServletException("Session exceeded");
        }
        String nodeIdString = request.getParameter("node");
        if (nodeIdString == null) {
            throw new MissingParameterException("node");
        }
        int nodeId = WebSecurityUtils.safeParseInt((String)nodeIdString);
        String intfIdString = request.getParameter("intf");
        if (intfIdString == null) {
            throw new MissingParameterException("intf");
        }
        int intfId = WebSecurityUtils.safeParseInt((String)intfIdString);
        String statusString = request.getParameter("status");
        if (statusString == null) {
            throw new MissingParameterException("status");
        }
        int status = WebSecurityUtils.safeParseInt((String)statusString);
        log.debug("ManageSnmpIntfServlet.doPost: parameters - node " + nodeId + " intf " + intfId + " status " + status);
        String snmpIp = null;
        Service[] snmpServices = null;
        try {
            snmpServices = NetworkElementFactory.getInstance(this.getServletContext()).getServicesOnNode(nodeId, this.snmpServiceId);
            if (snmpServices != null && snmpServices.length > 0) {
                ArrayList<InetAddress> ips = new ArrayList<InetAddress>();
                for (int i = 0; i < snmpServices.length; ++i) {
                    ips.add(InetAddressUtils.addr((String)snmpServices[i].getIpAddress()));
                }
                InetAddress lowest = InetAddressUtils.getLowestInetAddress(ips);
                if (lowest != null) {
                    snmpIp = InetAddressUtils.str((InetAddress)lowest);
                }
            }
            InetAddress[] inetAddress = InetAddress.getAllByName(snmpIp);
            SnmpAgentConfig agent = SnmpPeerFactory.getInstance().getAgentConfig(inetAddress[0]);
            log.debug("ManageSnmpIntfServlet.doPost: agent SNMP version/write community " + agent.getVersion() + "/" + agent.getWriteCommunity());
            SnmpIfAdmin snmpIfAdmin = new SnmpIfAdmin(nodeId, agent);
            if (snmpIfAdmin.setIfAdmin(intfId, status)) {
                log.debug("ManageSnmpIntfServlet.doPost: snmpIAdmin return OK ");
            } else {
                log.debug("ManageSnmpIntfServlet.doPost: snmpIAdmin return error ");
            }
            this.redirect(request, response);
        }
        catch (SQLException e) {
            throw new ServletException((Throwable)e);
        }
        catch (UnknownHostException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void redirect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirectURL = request.getHeader("Referer");
        response.sendRedirect(redirectURL);
    }
}

