/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.node;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.provision.persist.NodeProvisionService;
import org.opennms.web.MissingParameterException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.view.RedirectView;

public class NodeProvisioningController
extends AbstractController
implements InitializingBean {
    private NodeProvisionService m_nodeProvisionService;
    private String m_successView;
    private String m_redirectView;

    @Transactional
    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] required;
        String user = SecurityContextHolder.getContext().getAuthentication().getName();
        String action = request.getParameter("actionCode");
        String redirectParms = request.getParameter("redirectParms");
        String redirect = request.getParameter("redirect");
        if (action == null || !action.equals("add")) {
            ModelAndView modelAndView = this.m_nodeProvisionService.getModelAndView(request);
            modelAndView.setViewName(this.m_successView);
            return modelAndView;
        }
        for (String key : required = new String[]{"foreignSource", "nodeLabel", "ipAddress"}) {
            String[] value = request.getParameterValues(key);
            if (value != null && value.length != 0) continue;
            throw new MissingParameterException(key, required);
        }
        String foreignSource = request.getParameter("foreignSource");
        if (this.m_nodeProvisionService.provisionNode(user, foreignSource, String.valueOf(System.currentTimeMillis()), request.getParameter("nodeLabel"), request.getParameter("ipAddress"), request.getParameterValues("category"), request.getParameter("community"), request.getParameter("snmpVersion"), request.getParameter("deviceUsername"), request.getParameter("devicePassword"), request.getParameter("enablePassword"), request.getParameter("accessMethod"), request.getParameter("autoEnable"), request.getParameter("noSNMP"))) {
            redirectParms = "success=true&foreignSource=" + foreignSource;
        }
        String viewName = redirect != null ? redirect : (redirectParms == null || redirectParms == "" || redirectParms == "null" ? this.m_redirectView : this.m_redirectView + "?" + redirectParms);
        RedirectView view = new RedirectView(viewName, true);
        return new ModelAndView((View)view);
    }

    public void setRedirectView(String redirectView) {
        this.m_redirectView = redirectView;
    }

    public void setSuccessView(String successView) {
        this.m_successView = successView;
    }

    public void setNodeProvisionService(NodeProvisionService nodeProvisionService) {
        this.m_nodeProvisionService = nodeProvisionService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_redirectView, (String)"redirectView must be set");
        Assert.notNull((Object)this.m_successView, (String)"successView must be set");
        Assert.notNull((Object)this.m_nodeProvisionService, (String)"nodeProvisionService must be set");
    }
}

