/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.ksc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.web.svclayer.KscReportService;
import org.opennms.web.svclayer.ResourceService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class IndexController
extends AbstractController
implements InitializingBean {
    private ResourceService m_resourceService;
    private KscReportService m_kscReportService;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String reloadConfig = request.getParameter("reloadConfig");
        if (reloadConfig != null && Boolean.parseBoolean(reloadConfig)) {
            KSC_PerformanceReportFactory.getInstance().reload();
        }
        ModelAndView modelAndView = new ModelAndView("KSC/index");
        modelAndView.addObject("kscReadOnly", (Object)(!request.isUserInRole("ROLE_ADMIN") || request.isUserInRole("ROLE_READONLY") || request.getRemoteUser() == null ? 1 : 0));
        modelAndView.addObject("reports", this.getKscReportService().getReportList());
        modelAndView.addObject("nodeResources", this.getResourceService().findNodeResources());
        modelAndView.addObject("domainResources", this.getResourceService().findDomainResources());
        return modelAndView;
    }

    public ResourceService getResourceService() {
        return this.m_resourceService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.m_resourceService = resourceService;
    }

    public KscReportService getKscReportService() {
        return this.m_kscReportService;
    }

    public void setKscReportService(KscReportService kscReportService) {
        this.m_kscReportService = kscReportService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_resourceService != null ? 1 : 0) != 0, (String)"property resourceService must be set");
        Assert.state((this.m_kscReportService != null ? 1 : 0) != 0, (String)"property kscReportService must be set");
    }
}

