/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.ksc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.KscReportEditor;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.svclayer.KscReportService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class FormProcGraphController
extends AbstractController
implements InitializingBean {
    private KSC_PerformanceReportFactory m_kscReportFactory;
    private KscReportService m_kscReportService;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        KscReportEditor editor = KscReportEditor.getFromSession((HttpSession)request.getSession(), (boolean)true);
        Graph graph = editor.getWorkingGraph();
        String action = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.action.toString()));
        String timespan = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.timespan.toString()));
        String graphtype = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.graphtype.toString()));
        String title = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.title.toString()));
        String g_index = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.graphindex.toString()));
        int graph_index = WebSecurityUtils.safeParseInt((String)g_index);
        --graph_index;
        graph.setTitle(title);
        graph.setTimespan(timespan);
        graph.setGraphtype(graphtype);
        OnmsResource resource = this.getKscReportService().getResourceFromGraph(graph);
        if (action.equals("Save")) {
            editor.unloadWorkingGraph(graph_index);
        }
        if (action.equals("Save") || action.equals("Cancel")) {
            return new ModelAndView("redirect:/KSC/customReport.htm");
        }
        if (action.equals("Update")) {
            ModelAndView modelAndView = new ModelAndView("redirect:/KSC/customGraphEditDetails.htm");
            modelAndView.addObject("resourceId", (Object)resource.getId());
            modelAndView.addObject("graphtype", (Object)graph.getGraphtype());
            return modelAndView;
        }
        if (action.equals("ChooseResource")) {
            ModelAndView modelAndView = new ModelAndView("redirect:/KSC/customGraphChooseResource.htm");
            modelAndView.addObject("resourceId", (Object)resource.getId());
            modelAndView.addObject("selectedResourceId", (Object)resource.getId());
            return modelAndView;
        }
        throw new IllegalArgumentException("parameter action of '" + action + "' is not supported.  Must be one of: Save, Cancel, Update, or ChooseResource");
    }

    public KSC_PerformanceReportFactory getKscReportFactory() {
        return this.m_kscReportFactory;
    }

    public void setKscReportFactory(KSC_PerformanceReportFactory kscReportFactory) {
        this.m_kscReportFactory = kscReportFactory;
    }

    public KscReportService getKscReportService() {
        return this.m_kscReportService;
    }

    public void setKscReportService(KscReportService kscReportService) {
        this.m_kscReportService = kscReportService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_kscReportFactory != null ? 1 : 0) != 0, (String)"property kscReportFactory must be set");
        Assert.state((this.m_kscReportService != null ? 1 : 0) != 0, (String)"property kscReportService must be set");
    }

    public static enum Parameters {
        action,
        timespan,
        graphtype,
        title,
        graphindex;

    }
}

