/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.ksc;

import java.util.ArrayList;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.KscReportEditor;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.web.graph.KscResultSet;
import org.opennms.web.svclayer.KscReportService;
import org.opennms.web.svclayer.ResourceService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class CustomReportController
extends AbstractController
implements InitializingBean {
    private KSC_PerformanceReportFactory m_kscReportFactory;
    private KscReportService m_kscReportService;
    private ResourceService m_resourceService;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Report report = KscReportEditor.getFromSession((HttpSession)request.getSession(), (boolean)true).getWorkingReport();
        if (report == null) {
            throw new IllegalStateException("There is no working report");
        }
        ArrayList<KscResultSet> resultSets = new ArrayList<KscResultSet>(report.getGraphCount());
        for (int i = 0; i < report.getGraphCount(); ++i) {
            Graph current_graph = report.getGraph(i);
            PrefabGraph display_graph = this.getResourceService().getPrefabGraph(current_graph.getGraphtype());
            OnmsResource resource = this.getKscReportService().getResourceFromGraph(current_graph);
            Calendar begin_time = Calendar.getInstance();
            Calendar end_time = Calendar.getInstance();
            KSC_PerformanceReportFactory.getBeginEndTime((String)current_graph.getTimespan(), (Calendar)begin_time, (Calendar)end_time);
            KscResultSet resultSet = new KscResultSet(current_graph.getTitle(), begin_time.getTime(), end_time.getTime(), resource, display_graph);
            resultSets.add(resultSet);
        }
        ModelAndView modelAndView = new ModelAndView("KSC/customReport");
        modelAndView.addObject("showTimeSpan", (Object)report.getShow_timespan_button());
        modelAndView.addObject("showGraphType", (Object)report.getShow_graphtype_button());
        modelAndView.addObject("graphsPerLine", (Object)report.getGraphs_per_line());
        modelAndView.addObject("title", (Object)report.getTitle());
        modelAndView.addObject("resultSets", resultSets);
        return modelAndView;
    }

    public KSC_PerformanceReportFactory getKscReportFactory() {
        return this.m_kscReportFactory;
    }

    public void setKscReportFactory(KSC_PerformanceReportFactory kscReportFactory) {
        this.m_kscReportFactory = kscReportFactory;
    }

    public KscReportService getKscReportService() {
        return this.m_kscReportService;
    }

    public void setKscReportService(KscReportService kscReportService) {
        this.m_kscReportService = kscReportService;
    }

    public ResourceService getResourceService() {
        return this.m_resourceService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.m_resourceService = resourceService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_kscReportFactory != null ? 1 : 0) != 0, (String)"property kscReportFactory must be set");
        Assert.state((this.m_kscReportService != null ? 1 : 0) != 0, (String)"property kscReportService must be set");
        Assert.state((this.m_resourceService != null ? 1 : 0) != 0, (String)"property resourceService must be set");
    }
}

