/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.joda.time.Duration;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.PropertyPath;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.OnmsSeverityEditor;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.PrimaryTypeEditor;
import org.opennms.netmgt.provision.persist.ForeignSourceService;
import org.opennms.netmgt.provision.persist.StringIntervalPropertyEditor;
import org.opennms.netmgt.provision.persist.StringXmlCalendarPropertyEditor;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.web.rest.support.InetAddressTypeEditor;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

@Controller
public class EditForeignSourceController
extends SimpleFormController {
    private ForeignSourceService m_foreignSourceService;
    private static final Map<String, Set<String>> m_pluginParameters = new HashMap<String, Set<String>>();

    public void setForeignSourceService(ForeignSourceService fss) {
        this.m_foreignSourceService = fss;
    }

    protected void initBinder(HttpServletRequest req, ServletRequestDataBinder binder) throws Exception {
        binder.registerCustomEditor(Duration.class, (PropertyEditor)new StringIntervalPropertyEditor());
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequestInternal(request, response);
    }

    protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        TreeCommand treeCmd = (TreeCommand)command;
        LogUtils.debugf((Object)((Object)this), (String)"treeCmd = %s", (Object[])new Object[]{treeCmd});
        String action = treeCmd.getAction();
        if (action == null) {
            return this.doShow(request, response, treeCmd, errors);
        }
        if ("addDetector".equalsIgnoreCase(action)) {
            return this.doAddDetector(request, response, treeCmd, errors);
        }
        if ("addPolicy".equalsIgnoreCase(action)) {
            return this.doAddPolicy(request, response, treeCmd, errors);
        }
        if ("addParameter".equalsIgnoreCase(action)) {
            return this.doAddParameter(request, response, treeCmd, errors);
        }
        if ("save".equalsIgnoreCase(action)) {
            return this.doSave(request, response, treeCmd, errors);
        }
        if ("edit".equalsIgnoreCase(action)) {
            return this.doEdit(request, response, treeCmd, errors);
        }
        if ("cancel".equalsIgnoreCase(action)) {
            return this.doCancel(request, response, treeCmd, errors);
        }
        if ("delete".equalsIgnoreCase(action)) {
            return this.doDelete(request, response, treeCmd, errors);
        }
        if ("done".equalsIgnoreCase(action)) {
            return this.done(request, response, treeCmd, errors);
        }
        errors.reject("Unrecognized action: " + action);
        return this.showForm(request, response, errors);
    }

    private ModelAndView done(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        this.m_foreignSourceService.saveForeignSource(treeCmd.getForeignSourceName(), treeCmd.getFormData());
        return new ModelAndView(this.getSuccessView());
    }

    private ModelAndView doShow(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        return this.showForm(request, response, errors);
    }

    private ModelAndView doAddDetector(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        ForeignSource fs = this.m_foreignSourceService.addDetectorToForeignSource(treeCmd.getForeignSourceName(), "New Detector");
        treeCmd.setFormData(fs);
        treeCmd.setCurrentNode(treeCmd.getFormPath() + ".detectors[" + (fs.getDetectors().size() - 1) + "]");
        return this.showForm(request, response, errors);
    }

    private ModelAndView doAddPolicy(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        ForeignSource fs = this.m_foreignSourceService.addPolicyToForeignSource(treeCmd.getForeignSourceName(), "New Policy");
        treeCmd.setFormData(fs);
        treeCmd.setCurrentNode(treeCmd.getFormPath() + ".policies[" + (fs.getPolicies().size() - 1) + "]");
        return this.showForm(request, response, errors);
    }

    private ModelAndView doAddParameter(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        ForeignSource fs = this.m_foreignSourceService.addParameter(treeCmd.getForeignSourceName(), treeCmd.getDataPath());
        treeCmd.setFormData(fs);
        PropertyPath path = new PropertyPath(treeCmd.getDataPath());
        PluginConfig obj = (PluginConfig)path.getValue((Object)fs);
        int numParameters = obj.getParameters().size() - 1;
        treeCmd.setCurrentNode(treeCmd.getFormPath() + ".parameters[" + numParameters + "]");
        return this.showForm(request, response, errors);
    }

    private ModelAndView doSave(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        ForeignSource fs = this.m_foreignSourceService.saveForeignSource(treeCmd.getForeignSourceName(), treeCmd.getFormData());
        treeCmd.setFormData(fs);
        treeCmd.setCurrentNode("");
        return this.showForm(request, response, errors);
    }

    private ModelAndView doEdit(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        treeCmd.setCurrentNode(treeCmd.getFormPath());
        return this.showForm(request, response, errors);
    }

    private ModelAndView doCancel(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        ForeignSource fs = this.m_foreignSourceService.getForeignSource(treeCmd.getForeignSourceName());
        treeCmd.setFormData(fs);
        treeCmd.setCurrentNode("");
        return this.showForm(request, response, errors);
    }

    private ModelAndView doDelete(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        ForeignSource fs = this.m_foreignSourceService.deletePath(treeCmd.getForeignSourceName(), treeCmd.getDataPath());
        treeCmd.setFormData(fs);
        return this.showForm(request, response, errors);
    }

    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        TreeCommand formCommand = new TreeCommand();
        String foreignSourceName = request.getParameter("foreignSourceName");
        if (foreignSourceName == null) {
            throw new IllegalArgumentException("foreignSourceName required");
        }
        ForeignSource fs = this.m_foreignSourceService.getForeignSource(foreignSourceName);
        formCommand.setFormData(fs);
        return formCommand;
    }

    protected Map<String, Object> referenceData(HttpServletRequest request) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int classFieldWidth = 20;
        int valueFieldWidth = 20;
        TreeMap<String, Set<String>> classParameters = new TreeMap<String, Set<String>>();
        Map detectorTypes = this.m_foreignSourceService.getDetectorTypes();
        map.put("detectorTypes", detectorTypes);
        for (String key : detectorTypes.keySet()) {
            classParameters.put(key, this.getParametersForClass(key));
            classFieldWidth = Math.max(classFieldWidth, key.length());
        }
        Map policyTypes = this.m_foreignSourceService.getPolicyTypes();
        map.put("policyTypes", policyTypes);
        for (String key : policyTypes.keySet()) {
            classParameters.put(key, this.getParametersForClass(key));
            classFieldWidth = Math.max(classFieldWidth, key.length());
        }
        map.put("pluginInfo", this.m_foreignSourceService.getWrappers());
        map.put("classFieldWidth", classFieldWidth);
        map.put("valueFieldWidth", valueFieldWidth);
        return map;
    }

    private Set<String> getParametersForClass(String clazz) {
        if (m_pluginParameters.containsKey(clazz)) {
            return m_pluginParameters.get(clazz);
        }
        TreeSet<String> parameters = new TreeSet<String>();
        try {
            BeanWrapperImpl wrapper = new BeanWrapperImpl(Class.forName(clazz));
            wrapper.registerCustomEditor(XMLGregorianCalendar.class, (PropertyEditor)new StringXmlCalendarPropertyEditor());
            wrapper.registerCustomEditor(InetAddress.class, (PropertyEditor)new InetAddressTypeEditor());
            wrapper.registerCustomEditor(OnmsSeverity.class, (PropertyEditor)new OnmsSeverityEditor());
            wrapper.registerCustomEditor(PrimaryType.class, (PropertyEditor)new PrimaryTypeEditor());
            for (PropertyDescriptor pd : wrapper.getPropertyDescriptors()) {
                if ("class".equals(pd.getName())) continue;
                parameters.add(pd.getName());
            }
            m_pluginParameters.put(clazz, parameters);
            return parameters;
        }
        catch (ClassNotFoundException e) {
            this.log().warn("unable to wrap class " + clazz, (Throwable)e);
            return null;
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(EditForeignSourceController.class);
    }

    public static class TreeCommand {
        private String m_formPath;
        private String m_action;
        private ForeignSource m_formData;
        private String m_currentNode;
        private String m_foreignSourceName = "hardcoded";

        public String getAction() {
            return this.m_action;
        }

        public void setAction(String action) {
            this.m_action = action;
        }

        public String getForeignSourceName() {
            return this.m_foreignSourceName;
        }

        public void setForeignSourceName(String foreignSourceName) {
            this.m_foreignSourceName = foreignSourceName;
        }

        public ForeignSource getFormData() {
            return this.m_formData;
        }

        public void setFormData(ForeignSource importData) {
            this.m_formData = importData;
        }

        public String getDefaultFormPath() {
            return "foreignSourceEditForm.formData";
        }

        public String getFormPath() {
            return this.m_formPath;
        }

        public void setFormPath(String target) {
            this.m_formPath = target;
        }

        public String getCurrentNode() {
            return this.m_currentNode;
        }

        public void setCurrentNode(String node) {
            this.m_currentNode = node;
        }

        public String getDataPath() {
            return this.m_formPath.substring("foreignSourceEditForm.formData.".length());
        }

        public void setDataPath(String path) {
            this.m_formPath = "foreignSourceEditForm.formData." + path;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("foreign source", (Object)this.m_foreignSourceName).append("form path", (Object)this.m_formPath).append("action", (Object)this.m_action).append("form data", (Object)this.m_formData).append("current node", (Object)this.m_currentNode).toString();
        }
    }
}

