/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.reporting.core.svclayer.ReportStoreService;
import org.opennms.web.MissingParameterException;
import org.opennms.web.WebSecurityUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class DownloadReportController
extends AbstractController {
    private ReportStoreService m_reportStoreService;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] requiredParameters;
        for (String requiredParameter : requiredParameters = new String[]{"locatorId", "format"}) {
            if (request.getParameter(requiredParameter) != null) continue;
            throw new MissingParameterException(requiredParameter, requiredParameters);
        }
        try {
            Integer reportCatalogEntryId = new Integer(WebSecurityUtils.safeParseInt((String)request.getParameter("locatorId")));
            String requestFormat = new String(request.getParameter("format"));
            if (ReportFormat.PDF == ReportFormat.valueOf((String)requestFormat) || ReportFormat.SVG == ReportFormat.valueOf((String)requestFormat)) {
                response.setContentType("application/pdf;charset=UTF-8");
                response.setHeader("Content-disposition", "inline; filename=" + reportCatalogEntryId.toString() + ".pdf");
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "cache");
                response.setHeader("Cache-Control", "must-revalidate");
            }
            if (ReportFormat.CSV == ReportFormat.valueOf((String)requestFormat)) {
                response.setContentType("text/csv;charset=UTF-8");
                response.setHeader("Content-disposition", "inline; filename=" + reportCatalogEntryId.toString() + ".csv");
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "cache");
                response.setHeader("Cache-Control", "must-revalidate");
            }
            this.m_reportStoreService.render(reportCatalogEntryId, ReportFormat.valueOf((String)requestFormat), (OutputStream)response.getOutputStream());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return null;
    }

    public void setReportStoreService(ReportStoreService reportStoreService) {
        this.m_reportStoreService = reportStoreService;
    }
}

