/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.users.parsers;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class DutySchedule {
    private BitSet m_days = new BitSet(7);
    private int m_startTime;
    private int m_stopTime;
    public static final int MONDAY = 0;
    public static final int TUESDAY = 1;
    public static final int WEDNESDAY = 2;
    public static final int THURSDAY = 3;
    public static final int FRIDAY = 4;
    public static final int SATURDAY = 5;
    public static final int SUNDAY = 6;
    public static final String[] DAY_NAMES = new String[]{"Mo", "Tu", "We", "Th", "Fr", "Sa", "Su"};
    private static final int[] CALENDAR_DAY_MAPPING = new int[]{2, 3, 4, 5, 6, 7, 1};

    public DutySchedule() {
    }

    public DutySchedule(Vector<?> aSchedule) {
        for (int i = 0; i < 7; ++i) {
            if (!((Boolean)aSchedule.get(i)).booleanValue()) continue;
            this.m_days.set(i);
        }
        this.m_startTime = Integer.parseInt((String)aSchedule.get(7));
        this.m_stopTime = Integer.parseInt((String)aSchedule.get(8));
    }

    public DutySchedule(String aSchedule) {
        StringTokenizer timeTokens = new StringTokenizer(aSchedule, "-");
        String daysAndStartTime = timeTokens.nextToken();
        this.m_stopTime = Integer.parseInt(timeTokens.nextToken());
        for (int j = 0; j < daysAndStartTime.length(); ++j) {
            if (Character.isDigit(daysAndStartTime.charAt(j))) {
                this.m_startTime = Integer.parseInt(daysAndStartTime.substring(j, daysAndStartTime.length()));
                break;
            }
            this.m_days.set(this.getDayInt(daysAndStartTime.substring(j++, j + 1)));
        }
    }

    private int getDayInt(String aDay) {
        int value = -1;
        for (int i = 0; i < DAY_NAMES.length; ++i) {
            if (!aDay.equals(DAY_NAMES[i])) continue;
            value = i;
            break;
        }
        return value;
    }

    public void setDay(int aDay) {
        this.m_days.set(aDay);
    }

    public int getStartTime() {
        return this.m_startTime;
    }

    public int getStopTime() {
        return this.m_stopTime;
    }

    public List<Boolean> getDaysAsBooleanList() {
        ArrayList<Boolean> list = new ArrayList<Boolean>(this.m_days.size());
        for (int i = 0; i < this.m_days.size(); ++i) {
            list.add(this.m_days.get(i));
        }
        return list;
    }

    public Vector<Object> getAsVector() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < 7; ++i) {
            vector.add(new Boolean(this.m_days.get(i)));
        }
        vector.add(String.valueOf(this.m_startTime));
        vector.add(String.valueOf(this.m_stopTime));
        return vector;
    }

    public boolean isInSchedule(Calendar aTime) {
        boolean response = false;
        GregorianCalendar startTime = new GregorianCalendar(aTime.get(1), aTime.get(2), aTime.get(5));
        startTime.set(11, this.m_startTime / 100);
        startTime.set(12, this.m_startTime % 100);
        startTime.set(13, 0);
        GregorianCalendar endTime = new GregorianCalendar(aTime.get(1), aTime.get(2), aTime.get(5));
        endTime.set(11, this.m_stopTime / 100);
        endTime.set(12, this.m_stopTime % 100);
        endTime.set(13, 0);
        for (int i = 0; i < 7; ++i) {
            if (!this.m_days.get(i) || CALENDAR_DAY_MAPPING[i] != aTime.get(7)) continue;
            long dateMillis = aTime.getTime().getTime();
            long startMillis = startTime.getTime().getTime();
            long endMillis = endTime.getTime().getTime();
            if (startMillis > dateMillis || dateMillis > endMillis) continue;
            response = true;
            break;
        }
        return response;
    }

    public void setStartHour(int anHour) {
        this.m_startTime = anHour;
    }

    public void setEndHour(int anHour) {
        this.m_stopTime = anHour;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < DAY_NAMES.length; ++i) {
            if (!this.m_days.get(i)) continue;
            buffer.append(DAY_NAMES[i]);
        }
        buffer.append(this.m_startTime + "-" + this.m_stopTime);
        return buffer.toString();
    }

    public boolean hasDay(int aDay) {
        return this.m_days.get(aDay);
    }

    public DutySchedule clone() {
        return new DutySchedule(this.toString());
    }
}

