/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.groups;

import java.io.IOException;
import java.text.ChoiceFormat;
import java.util.List;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.config.users.DutySchedule;
import org.opennms.web.WebSecurityUtils;

public class UpdateGroupServlet
extends HttpServlet {
    private static final long serialVersionUID = -4328190323404240442L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession userSession = request.getSession(false);
        if (userSession != null) {
            Group newGroup = (Group)userSession.getAttribute("group");
            newGroup.removeAllUser();
            String[] users = request.getParameterValues("selectedUsers");
            if (users != null) {
                for (int i = 0; i < users.length; ++i) {
                    newGroup.addUser(users[i]);
                }
            }
            Vector<Object> newSchedule = new Vector<Object>();
            ChoiceFormat days = new ChoiceFormat("0#Mo|1#Tu|2#We|3#Th|4#Fr|5#Sa|6#Su");
            List<String> dutySchedules = this.getDutySchedulesForGroup(newGroup);
            dutySchedules.clear();
            int dutyCount = WebSecurityUtils.safeParseInt((String)request.getParameter("dutySchedules"));
            for (int duties = 0; duties < dutyCount; ++duties) {
                newSchedule.clear();
                String deleteFlag = request.getParameter("deleteDuty" + duties);
                if (deleteFlag != null) continue;
                for (int i = 0; i < 7; ++i) {
                    String curDayFlag = request.getParameter("duty" + duties + days.format(i));
                    if (curDayFlag != null) {
                        newSchedule.addElement(Boolean.TRUE);
                        continue;
                    }
                    newSchedule.addElement(Boolean.FALSE);
                }
                newSchedule.addElement(request.getParameter("duty" + duties + "Begin"));
                newSchedule.addElement(request.getParameter("duty" + duties + "End"));
                DutySchedule newDuty = new DutySchedule(newSchedule);
                dutySchedules.add(newDuty.toString());
            }
            userSession.setAttribute("group", (Object)newGroup);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(request.getParameter("redirect"));
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private List<String> getDutySchedulesForGroup(Group group) {
        return group.getDutyScheduleCollection();
    }
}

