/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.MinionDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.OnmsMinionCollection;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.minion.OnmsMinion;
import org.opennms.web.rest.support.SearchProperties;
import org.opennms.web.rest.support.SearchProperty;
import org.opennms.web.rest.v2.AbstractDaoRestService;
import org.opennms.web.svclayer.api.RequisitionAccessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="minions")
@Transactional
public class MinionRestService
extends AbstractDaoRestService<OnmsMinion, OnmsMinion, String, String> {
    private static final Logger LOG = LoggerFactory.getLogger(MinionRestService.class);
    private static final String PROVISIONING_FOREIGN_SOURCE_PATTERN = System.getProperty("opennms.minion.provisioning.foreignSourcePattern", "Minions");
    @Autowired
    private MinionDao m_dao;
    @Autowired
    @Qualifier(value="eventProxy")
    private EventProxy m_eventProxy;
    @Autowired
    private RequisitionAccessService m_requisitionAccessService;

    protected MinionDao getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<OnmsMinion> getDaoClass() {
        return OnmsMinion.class;
    }

    @Override
    protected Class<OnmsMinion> getQueryBeanClass() {
        return OnmsMinion.class;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsMinion.class);
        builder.orderBy("label").desc();
        return builder;
    }

    @Override
    protected JaxbListWrapper<OnmsMinion> createListWrapper(Collection<OnmsMinion> list) {
        return new OnmsMinionCollection(list);
    }

    @Override
    protected Set<SearchProperty> getQueryProperties() {
        return SearchProperties.MINION_SERVICE_PROPERTIES;
    }

    @Override
    protected Response doUpdate(SecurityContext securityContext, UriInfo uriInfo, String key, OnmsMinion targetObject) {
        if (!key.equals(targetObject.getId())) {
            throw this.getException(Response.Status.BAD_REQUEST, "The ID of the object doesn't match the ID of the path: {} != {}", targetObject.getId(), key);
        }
        this.getDao().saveOrUpdate((Object)targetObject);
        return Response.noContent().build();
    }

    @Override
    protected void doDelete(SecurityContext securityContext, UriInfo uriInfo, OnmsMinion minion) {
        String location = minion.getLocation();
        String id = minion.getId();
        this.getDao().delete((Object)minion);
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/monitoringSystemDeleted", "ReST");
        eventBuilder.addParam("monitoringSystemType", "Minion");
        eventBuilder.addParam("monitoringSystemId", id);
        eventBuilder.addParam("monitoringSystemLocation", location);
        try {
            this.m_eventProxy.send(eventBuilder.getEvent());
        }
        catch (EventProxyException e) {
            LOG.warn("Failed to send Event on Minion deletion " + e.getMessage(), (Throwable)e);
        }
        String foreignSource = String.format(PROVISIONING_FOREIGN_SOURCE_PATTERN, minion.getLocation());
        this.m_requisitionAccessService.deleteNode(foreignSource, minion.getId());
    }

    @Override
    protected OnmsMinion doGet(UriInfo uriInfo, String id) {
        return (OnmsMinion)this.getDao().get((Serializable)((Object)id));
    }
}

