/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.api.CollectdConfigFactory;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.provision.persist.ForeignSourceService;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.support.PluginWrapper;
import org.opennms.web.rest.v1.OnmsRestService;
import org.opennms.web.svclayer.support.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="foreignSourceConfigRestService")
@Path(value="foreignSourcesConfig")
public class ForeignSourceConfigRestService
extends OnmsRestService
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ForeignSourceConfigRestService.class);
    @Autowired
    protected ForeignSourceService m_foreignSourceService;
    @Autowired
    protected PollerConfig m_pollerConfig;
    @Autowired
    protected CollectdConfigFactory m_collectdConfigFactory;
    @Autowired
    private CategoryDao m_categoryDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_foreignSourceService, (String)"ForeignSourceService is required.");
        this.m_foreignSourceService.getPolicyTypes();
        this.m_foreignSourceService.getDetectorTypes();
    }

    @GET
    @Path(value="policies")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public SimplePluginConfigList getAvailablePolicies() {
        return this.getPlugins(true);
    }

    @GET
    @Path(value="detectors")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public SimplePluginConfigList getAvailableDetectors() {
        return this.getPlugins(false);
    }

    @GET
    @Path(value="services/{groupName}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public ElementList getServices(@PathParam(value="groupName") String groupName) {
        ElementList elements = new ElementList(this.m_pollerConfig.getServiceMonitorNames());
        this.m_collectdConfigFactory.getCollectdConfig().getCollectors().forEach(c -> {
            if (!elements.contains(c.getService())) {
                elements.add(c.getService());
            }
        });
        if (groupName != null) {
            TreeSet<String> serviceNames = new TreeSet<String>();
            ForeignSource pendingForeignSource = this.m_foreignSourceService.getForeignSource(groupName);
            serviceNames.addAll(pendingForeignSource.getDetectorNames());
            for (OnmsServiceType type : this.m_serviceTypeDao.findAll()) {
                serviceNames.add(type.getName());
            }
            if (this.m_pollerConfig != null && this.m_pollerConfig.getServiceMonitorNames() != null && !this.m_pollerConfig.getServiceMonitorNames().isEmpty()) {
                serviceNames.addAll(this.m_pollerConfig.getServiceMonitorNames());
            }
            serviceNames.forEach(s -> {
                if (!elements.contains(s)) {
                    elements.add(s);
                }
            });
        }
        return elements;
    }

    @GET
    @Path(value="assets")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public ElementList getAssets() {
        ArrayList blackList = Lists.newArrayList((Object[])new String[]{"id", "class", "geolocation", "node"});
        Collection assets = PropertyUtils.getProperties((Object)new OnmsAssetRecord()).stream().filter(a -> !blackList.contains(a)).collect(Collectors.toList());
        return new ElementList(assets);
    }

    @GET
    @Path(value="categories")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public ElementList getCategories() {
        Set categories = this.m_categoryDao.findAll().stream().map(c -> c.getName()).collect(Collectors.toSet());
        return new ElementList(categories);
    }

    protected SimplePluginConfigList getPlugins(boolean isPolicies) {
        SimplePluginConfigList plugins = new SimplePluginConfigList();
        Map typesMap = isPolicies ? this.m_foreignSourceService.getPolicyTypes() : this.m_foreignSourceService.getDetectorTypes();
        for (String pluginClass : typesMap.keySet()) {
            PluginWrapper wrapper = (PluginWrapper)this.m_foreignSourceService.getWrappers().get(pluginClass);
            if (wrapper == null) {
                LOG.warn("No wrapper found for plugin class {}. See previous log messages for wrapping failures.", (Object)pluginClass);
                continue;
            }
            String pluginName = (String)typesMap.get(pluginClass);
            SimplePluginConfig cfg = new SimplePluginConfig(pluginName, pluginClass);
            ArrayList<SimplePluginParameter> requiredParams = new ArrayList<SimplePluginParameter>();
            ArrayList<SimplePluginParameter> optionalParams = new ArrayList<SimplePluginParameter>();
            for (Map.Entry paramEntry : wrapper.getRequired().entrySet()) {
                Boolean required = (Boolean)paramEntry.getValue();
                String paramName = (String)paramEntry.getKey();
                Set options = required != false ? (Set)wrapper.getRequiredItems().get(paramName) : (Set)wrapper.getOptionalItems().get(paramName);
                ArrayList<String> optionList = new ArrayList<String>(options);
                Collections.sort(optionList);
                SimplePluginParameter param = new SimplePluginParameter(paramName, required, optionList);
                if (required.booleanValue()) {
                    requiredParams.add(param);
                    continue;
                }
                optionalParams.add(param);
            }
            Collections.sort(requiredParams, new ParameterComparator());
            Collections.sort(optionalParams, new ParameterComparator());
            cfg.parameters.addAll(requiredParams);
            cfg.parameters.addAll(optionalParams);
            plugins.add(cfg);
        }
        return plugins;
    }

    public static class ParameterComparator
    implements Comparator<SimplePluginParameter> {
        @Override
        public int compare(SimplePluginParameter o1, SimplePluginParameter o2) {
            return o1.key.compareTo(o2.key);
        }
    }

    @XmlRootElement(name="elements")
    public static class ElementList
    extends JaxbListWrapper<String> {
        public ElementList() {
        }

        public ElementList(Collection<? extends String> c) {
            super(c);
        }

        @XmlElement(name="element")
        public List<String> getElements() {
            List elements = this.getObjects();
            Collections.sort(elements);
            return elements;
        }
    }

    @XmlRootElement(name="parameter")
    @XmlType(propOrder={"key", "required", "options"})
    public static class SimplePluginParameter {
        @XmlAttribute
        public String key;
        @XmlAttribute
        public Boolean required;
        @XmlElement(name="option")
        @XmlElementWrapper(name="options")
        public List<String> options = new ArrayList<String>();

        public SimplePluginParameter() {
        }

        public SimplePluginParameter(String key, Boolean required, List<String> options) {
            this.key = key;
            this.required = required;
            this.options = options;
        }
    }

    @XmlRootElement(name="plugin")
    @XmlType(propOrder={"name", "pluginClass", "parameters"})
    public static class SimplePluginConfig {
        @XmlAttribute(name="name")
        public String name;
        @XmlAttribute(name="class")
        public String pluginClass;
        @XmlElement(name="parameter")
        @XmlElementWrapper(name="parameters")
        public List<SimplePluginParameter> parameters = new ArrayList<SimplePluginParameter>();

        public SimplePluginConfig() {
        }

        public SimplePluginConfig(String name, String pluginClass) {
            this.name = name;
            this.pluginClass = pluginClass;
        }
    }

    @XmlRootElement(name="plugin-configuration")
    public static class SimplePluginConfigList
    extends JaxbListWrapper<SimplePluginConfig> {
        @XmlElement(name="plugin")
        @XmlElementWrapper(name="plugins")
        public List<SimplePluginConfig> getPlugins() {
            return this.getObjects();
        }
    }
}

