/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonRootName;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.OnmsDao;
import org.opennms.netmgt.enlinkd.model.UserDefinedLink;
import org.opennms.netmgt.enlinkd.persistence.api.UserDefinedLinkDao;
import org.opennms.netmgt.enlinkd.service.api.UserDefinedLinkTopologyService;
import org.opennms.web.api.RestUtils;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.support.RedirectHelper;
import org.opennms.web.rest.v2.AbstractDaoRestService;
import org.opennms.web.rest.v2.NodeCategoriesRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="userdefinedlinks")
@Transactional
public class UserDefinedLinkRestService
extends AbstractDaoRestService<UserDefinedLink, UserDefinedLink, Integer, Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(NodeCategoriesRestService.class);
    @Autowired(required=false)
    private UserDefinedLinkDao m_dao;
    @Autowired(required=false)
    private UserDefinedLinkTopologyService m_service;

    @Override
    protected OnmsDao<UserDefinedLink, Integer> getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<UserDefinedLink> getDaoClass() {
        return UserDefinedLink.class;
    }

    @Override
    protected Class<UserDefinedLink> getQueryBeanClass() {
        return UserDefinedLink.class;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        return new CriteriaBuilder(this.getDaoClass()).distinct();
    }

    @Override
    protected JaxbListWrapper<UserDefinedLink> createListWrapper(Collection<UserDefinedLink> list) {
        return new UserDefinedLinkCollection(list);
    }

    @Override
    protected UserDefinedLink doGet(UriInfo uriInfo, Integer id) {
        return (UserDefinedLink)this.m_dao.get((Serializable)id);
    }

    @Override
    public Response doCreate(SecurityContext securityContext, UriInfo uriInfo, UserDefinedLink udl) {
        if (udl == null) {
            throw this.getException(Response.Status.BAD_REQUEST, "Link cannot be null", new String[0]);
        }
        this.m_service.saveOrUpdate(udl);
        return Response.created((URI)RedirectHelper.getRedirectUri(uriInfo, udl.getDbId())).build();
    }

    @Override
    protected Response doUpdateProperties(SecurityContext securityContext, UriInfo uriInfo, UserDefinedLink udl, MultivaluedMapImpl params) {
        RestUtils.setBeanProperties((Object)udl, (MultivaluedMap)params);
        this.m_service.saveOrUpdate(udl);
        return Response.noContent().build();
    }

    @Override
    protected void doDelete(SecurityContext securityContext, UriInfo uriInfo, UserDefinedLink udl) {
        this.m_service.delete(udl);
    }

    @XmlRootElement(name="user_defined_links")
    @JsonRootName(value="user_defined_links")
    public static class UserDefinedLinkCollection
    extends JaxbListWrapper<UserDefinedLink> {
        private static final long serialVersionUID = 1L;

        public UserDefinedLinkCollection() {
        }

        public UserDefinedLinkCollection(Collection<? extends UserDefinedLink> udls) {
            super(udls);
        }

        @XmlElement(name="user_defined_link")
        @JsonProperty(value="user_defined_link")
        public List<UserDefinedLink> getObjects() {
            return super.getObjects();
        }
    }
}

