/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.beans.PropertyEditor;
import java.io.Serializable;
import java.net.URI;
import java.text.ParseException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.Duration;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.provision.persist.StringIntervalPropertyEditor;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.OnmsRestService;
import org.opennms.web.rest.v1.support.OnmsMonitoringLocationDefinitionList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="monitoringLocationsRestService")
@Path(value="monitoringLocations")
public class MonitoringLocationsRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(MonitoringLocationsRestService.class);
    @Autowired
    private MonitoringLocationDao m_monitoringLocationDao;

    @GET
    @Path(value="default")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public LocationDef getDefaultMonitoringLocation() throws ParseException {
        return (LocationDef)this.m_monitoringLocationDao.findAll().get(0);
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public OnmsMonitoringLocationDefinitionList getForeignSources() throws ParseException {
        return new OnmsMonitoringLocationDefinitionList(this.m_monitoringLocationDao.findAll());
    }

    @GET
    @Path(value="count")
    @Produces(value={"text/plain"})
    public String getTotalCount() throws ParseException {
        return Integer.toString(this.m_monitoringLocationDao.findAll().size());
    }

    @GET
    @Path(value="{monitoringLocation}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public LocationDef getMonitoringLocation(@PathParam(value="monitoringLocation") String monitoringLocation) {
        LocationDef loc = (LocationDef)this.m_monitoringLocationDao.get((Serializable)((Object)monitoringLocation));
        if (loc == null) {
            throw MonitoringLocationsRestService.getException(Response.Status.NOT_FOUND, "Monitoring location {} was not found.", monitoringLocation);
        }
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    public Response addMonitoringLocation(@Context UriInfo uriInfo, LocationDef monitoringLocation) {
        this.writeLock();
        try {
            LOG.debug("addMonitoringLocation: Adding monitoringLocation {}", (Object)monitoringLocation.getLocationName());
            this.m_monitoringLocationDao.save((Object)monitoringLocation);
            Response response = Response.created((URI)MonitoringLocationsRestService.getRedirectUri(uriInfo, monitoringLocation.getLocationName())).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{monitoringLocation}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateMonitoringLocation(@PathParam(value="monitoringLocation") String monitoringLocation, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            Response response;
            LocationDef def = (LocationDef)this.m_monitoringLocationDao.get((Serializable)((Object)monitoringLocation));
            LOG.debug("updateMonitoringLocation: updating monitoring location {}", (Object)monitoringLocation);
            if (params.isEmpty()) {
                Response response2 = Response.notModified().build();
                return response2;
            }
            boolean modified = false;
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)def);
            wrapper.registerCustomEditor(Duration.class, (PropertyEditor)new StringIntervalPropertyEditor());
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                Object value = null;
                String stringValue = (String)params.getFirst(key);
                value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
                modified = true;
            }
            if (modified) {
                LOG.debug("updateMonitoringLocation: monitoring location {} updated", (Object)monitoringLocation);
                this.m_monitoringLocationDao.save((Object)def);
                response = Response.noContent().build();
                return response;
            }
            response = Response.notModified().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="{monitoringLocation}")
    @Transactional
    public Response deleteMonitoringLocation(@PathParam(value="monitoringLocation") String monitoringLocation) {
        this.writeLock();
        try {
            LOG.debug("deleteMonitoringLocation: deleting monitoring location {}", (Object)monitoringLocation);
            this.m_monitoringLocationDao.delete((Serializable)((Object)monitoringLocation));
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }
}

