/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.opennms.api.reporting.ReportMode;
import org.opennms.api.reporting.ReportParameterBuilder;
import org.opennms.api.reporting.parameter.ReportDateParm;
import org.opennms.api.reporting.parameter.ReportDoubleParm;
import org.opennms.api.reporting.parameter.ReportFloatParm;
import org.opennms.api.reporting.parameter.ReportIntParm;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.api.reporting.parameter.ReportParmVisitor;
import org.opennms.api.reporting.parameter.ReportStringParm;
import org.opennms.api.reporting.parameter.ReportTimezoneParm;
import org.opennms.reporting.core.DeliveryOptions;
import org.opennms.reporting.core.svclayer.DeliveryConfig;
import org.opennms.reporting.core.svclayer.ScheduleConfig;
import org.opennms.web.svclayer.SchedulerService;
import org.opennms.web.svclayer.model.TriggerDescription;
import org.opennms.web.svclayer.support.InvalidCronExpressionException;
import org.opennms.web.svclayer.support.SchedulerContextException;
import org.opennms.web.svclayer.support.SchedulerException;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class DefaultSchedulerService
implements InitializingBean,
SchedulerService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchedulerService.class);
    private static final String PROVIDE_A_VALUE_TEXT = "Please provide a value";
    private static final String PROVIDED_VALUE_GREATER_ZERO_TEXT = "The provided value must be > 0";
    private Scheduler m_scheduler;
    private JobDetail m_jobDetail;
    private String m_triggerGroup;

    public void afterPropertiesSet() throws Exception {
        LOG.debug("Adding job {} to scheduler", (Object)this.m_jobDetail.getKey().getName());
        this.m_scheduler.addJob(this.m_jobDetail, true);
    }

    @Override
    public List<TriggerDescription> getTriggerDescriptions() {
        ArrayList<TriggerDescription> triggerDescriptions = new ArrayList<TriggerDescription>();
        try {
            Set triggerKeys = this.m_scheduler.getTriggerKeys(GroupMatcher.groupEquals((String)this.m_triggerGroup));
            for (TriggerKey triggerKey : triggerKeys) {
                TriggerDescription description = new TriggerDescription();
                Trigger trigger = this.m_scheduler.getTrigger(triggerKey);
                description.setNextFireTime(trigger.getNextFireTime());
                description.setTriggerName(triggerKey.getName());
                description.setReportId((String)trigger.getJobDataMap().get((Object)"reportId"));
                description.setDeliveryOptions((DeliveryOptions)trigger.getJobDataMap().get((Object)"deliveryOptions"));
                description.setReportParameters((ReportParameters)trigger.getJobDataMap().get((Object)"criteria"));
                if (trigger instanceof CronTriggerImpl) {
                    description.setCronExpression(((CronTriggerImpl)trigger).getCronExpression());
                }
                triggerDescriptions.add(description);
            }
        }
        catch (org.quartz.SchedulerException e) {
            LOG.error("exception retrieving trigger descriptions", (Throwable)e);
            throw new SchedulerException("Could not retrieve triggers: " + e.getMessage(), (Exception)((Object)e));
        }
        return triggerDescriptions;
    }

    @Override
    public Boolean exists(String triggerName) {
        Objects.requireNonNull(triggerName);
        try {
            Trigger trigger = this.m_scheduler.getTrigger(new TriggerKey(triggerName, this.m_triggerGroup));
            if (trigger != null) {
                return true;
            }
        }
        catch (org.quartz.SchedulerException e) {
            LOG.error("exception looking up trigger name: {}", (Object)triggerName, (Object)e);
            throw new SchedulerException("Could not retrieve trigger '" + triggerName + " ': " + e.getMessage(), (Exception)((Object)e));
        }
        return false;
    }

    @Override
    public void removeTrigger(String triggerName) {
        try {
            this.m_scheduler.unscheduleJob(new TriggerKey(triggerName, this.m_triggerGroup));
        }
        catch (org.quartz.SchedulerException e) {
            LOG.error("exception when attempting to remove trigger {}", (Object)triggerName, (Object)e);
            throw new SchedulerException("Could not remove trigger '" + triggerName + " ': " + e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    public void removeTriggers(String[] triggerNames) {
        for (String triggerName : triggerNames) {
            this.removeTrigger(triggerName);
        }
    }

    @Override
    public void updateCronTrigger(String cronTrigger, ScheduleConfig scheduleConfig) {
        Objects.requireNonNull(cronTrigger);
        Objects.requireNonNull(scheduleConfig);
        this.validate((DeliveryConfig)scheduleConfig, ReportMode.SCHEDULED, true);
        TriggerKey triggerKey = new TriggerKey(cronTrigger, this.m_triggerGroup);
        ReportParameters parameters = scheduleConfig.getReportParameters();
        DeliveryOptions deliveryOptions = scheduleConfig.getDeliveryOptions();
        String cronExpression = scheduleConfig.getCronExpression();
        try {
            Trigger trigger = this.m_scheduler.getTrigger(triggerKey);
            trigger.getJobDataMap().put("criteria", (Object)parameters);
            trigger.getJobDataMap().put("deliveryOptions", (Object)deliveryOptions);
            trigger.getJobDataMap().put("cronExpression", cronExpression);
            ((CronTriggerImpl)trigger).setCronExpression(cronExpression);
            this.m_scheduler.rescheduleJob(triggerKey, trigger);
        }
        catch (org.quartz.SchedulerException e) {
            LOG.error("Could not update cron trigger {}:{}", new Object[]{cronTrigger, e.getMessage(), e});
            throw new SchedulerException("An unexpected error occurred while updating cron trigger " + cronTrigger, (Exception)((Object)e));
        }
        catch (ParseException e) {
            LOG.error("Provided cron expression '{}' could not be parsed", (Object)cronExpression, (Object)e);
            throw new InvalidCronExpressionException(e, cronExpression);
        }
    }

    @Override
    public void addCronTrigger(ScheduleConfig scheduleConfig) {
        Objects.requireNonNull(scheduleConfig);
        this.validate((DeliveryConfig)scheduleConfig, ReportMode.SCHEDULED, false);
        CronTriggerImpl cronTrigger = new CronTriggerImpl();
        ReportParameters parameters = scheduleConfig.getReportParameters();
        DeliveryOptions deliveryOptions = scheduleConfig.getDeliveryOptions();
        String cronExpression = scheduleConfig.getCronExpression();
        try {
            cronTrigger.setGroup(this.m_triggerGroup);
            cronTrigger.setName(deliveryOptions.getInstanceId());
            cronTrigger.setJobName(this.m_jobDetail.getKey().getName());
            cronTrigger.setCronExpression(cronExpression);
        }
        catch (ParseException e) {
            LOG.error("Provided cron expression '{}' could not be parsed", (Object)cronExpression, (Object)e);
            throw new InvalidCronExpressionException(e, cronExpression);
        }
        cronTrigger.setJobName(this.m_jobDetail.getKey().getName());
        cronTrigger.getJobDataMap().put("criteria", (Object)parameters);
        cronTrigger.getJobDataMap().put("reportId", parameters.getReportId());
        cronTrigger.getJobDataMap().put("deliveryOptions", (Object)deliveryOptions);
        cronTrigger.getJobDataMap().put("mode", (Object)ReportMode.SCHEDULED);
        try {
            this.m_scheduler.scheduleJob((Trigger)cronTrigger);
        }
        catch (org.quartz.SchedulerException e) {
            throw new SchedulerException((Exception)((Object)e));
        }
    }

    @Override
    public void execute(DeliveryConfig deliveryConfig) {
        Objects.requireNonNull(deliveryConfig);
        this.validate(deliveryConfig, ReportMode.IMMEDIATE, false);
        ReportParameters parameters = deliveryConfig.getReportParameters();
        DeliveryOptions deliveryOptions = deliveryConfig.getDeliveryOptions();
        SimpleTriggerImpl trigger = new SimpleTriggerImpl(deliveryOptions.getInstanceId(), this.m_triggerGroup, new Date(), null, 0, 0L);
        trigger.setJobName(this.m_jobDetail.getKey().getName());
        trigger.getJobDataMap().put("criteria", (Object)parameters);
        trigger.getJobDataMap().put("reportId", parameters.getReportId());
        trigger.getJobDataMap().put("deliveryOptions", (Object)deliveryOptions);
        trigger.getJobDataMap().put("mode", (Object)ReportMode.IMMEDIATE);
        try {
            this.m_scheduler.scheduleJob((Trigger)trigger);
        }
        catch (org.quartz.SchedulerException e) {
            throw new SchedulerException((Exception)((Object)e));
        }
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public void setJobDetail(JobDetail reportJob) {
        this.m_jobDetail = reportJob;
    }

    public void setTriggerGroup(String triggerGroup) {
        this.m_triggerGroup = triggerGroup;
    }

    private void validate(DeliveryConfig deliveryConfig, ReportMode reportMode, boolean update) {
        Objects.requireNonNull(deliveryConfig);
        Objects.requireNonNull(reportMode);
        this.validate(deliveryConfig.getReportParameters(), reportMode);
        this.validate(deliveryConfig.getDeliveryOptions(), update);
    }

    private void validate(DeliveryOptions deliveryOptions, boolean update) {
        block14: {
            Objects.requireNonNull(deliveryOptions);
            try {
                if (!update) {
                    Set intanceIds = this.m_scheduler.getTriggerKeys(GroupMatcher.groupEquals((String)this.m_triggerGroup)).stream().map(tk -> tk.getName()).collect(Collectors.toSet());
                    if (intanceIds.contains(deliveryOptions.getInstanceId())) {
                        throw new SchedulerContextException("instanceId", "The provided value already exists");
                    }
                    if (Strings.isNullOrEmpty((String)deliveryOptions.getInstanceId())) {
                        throw new SchedulerContextException("instanceId", PROVIDE_A_VALUE_TEXT);
                    }
                }
                if (!(deliveryOptions.isSendMail() || deliveryOptions.isPersist() || deliveryOptions.isWebhook())) {
                    throw new SchedulerContextException("sendMail_persist_webhook", "Either sendMail, webhook or persist must be set");
                }
                if (deliveryOptions.getFormat() == null) {
                    throw new SchedulerContextException("format", PROVIDE_A_VALUE_TEXT);
                }
                if (deliveryOptions.isSendMail()) {
                    if (Strings.isNullOrEmpty((String)deliveryOptions.getMailTo())) {
                        throw new SchedulerContextException("mailTo", PROVIDE_A_VALUE_TEXT);
                    }
                    try {
                        InternetAddress.parse((String)deliveryOptions.getMailTo(), (boolean)false);
                    }
                    catch (AddressException e) {
                        throw new SchedulerContextException("mailTo", "Provided recipients could not be parsed: {0}", new Object[]{e.getMessage(), e});
                    }
                }
                if (!deliveryOptions.isWebhook()) break block14;
                if (Strings.isNullOrEmpty((String)deliveryOptions.getWebhookUrl())) {
                    throw new SchedulerContextException("webhookUrl", PROVIDE_A_VALUE_TEXT);
                }
                try {
                    new URL(deliveryOptions.getWebhookUrl());
                }
                catch (MalformedURLException ex) {
                    throw new SchedulerContextException("webhookUrl", "The provided URL ''{0}'' is not valid: ''{1}''", deliveryOptions.getWebhookUrl(), ex.getMessage());
                }
            }
            catch (org.quartz.SchedulerException e) {
                throw new SchedulerException((Exception)((Object)e));
            }
        }
    }

    private void validate(ReportParameters reportParameters, ReportMode reportMode) {
        Objects.requireNonNull(reportParameters);
        Objects.requireNonNull(reportMode);
        ParameterRequiredVisitor validator = new ParameterRequiredVisitor(reportMode);
        if (reportParameters.getStringParms() != null) {
            for (ReportStringParm eachParm : reportParameters.getStringParms()) {
                validator.visit(eachParm);
            }
        }
        if (reportParameters.getIntParms() != null) {
            for (ReportStringParm eachParm : reportParameters.getIntParms()) {
                validator.visit((ReportIntParm)eachParm);
            }
        }
        if (reportParameters.getFloatParms() != null) {
            for (ReportStringParm eachParm : reportParameters.getFloatParms()) {
                validator.visit((ReportFloatParm)eachParm);
            }
        }
        if (reportParameters.getDoubleParms() != null) {
            for (ReportStringParm eachParm : reportParameters.getDoubleParms()) {
                validator.visit((ReportDoubleParm)eachParm);
            }
        }
        if (reportParameters.getDateParms() != null) {
            for (ReportStringParm eachParm : reportParameters.getDateParms()) {
                validator.visit((ReportDateParm)eachParm);
            }
        }
    }

    private static class ParameterRequiredVisitor
    implements ReportParmVisitor {
        private final ReportMode mode;

        public ParameterRequiredVisitor(ReportMode reportMode) {
            this.mode = Objects.requireNonNull(reportMode);
        }

        public void visit(ReportStringParm parm) {
            if (Strings.isNullOrEmpty((String)parm.getValue())) {
                throw new SchedulerContextException(parm.getName(), DefaultSchedulerService.PROVIDE_A_VALUE_TEXT);
            }
        }

        public void visit(ReportIntParm parm) {
        }

        public void visit(ReportFloatParm parm) {
            if (parm.getValue() == null) {
                throw new SchedulerContextException(parm.getName(), DefaultSchedulerService.PROVIDE_A_VALUE_TEXT);
            }
        }

        public void visit(ReportDoubleParm parm) {
            if (parm.getValue() == null) {
                throw new SchedulerContextException(parm.getName(), DefaultSchedulerService.PROVIDE_A_VALUE_TEXT);
            }
        }

        public void visit(ReportTimezoneParm parm) {
            if (parm.getValue() == null) {
                throw new SchedulerContextException(parm.getName(), DefaultSchedulerService.PROVIDE_A_VALUE_TEXT);
            }
        }

        public void visit(ReportDateParm parm) {
            if (parm.getUseAbsoluteDate().booleanValue() || this.mode == ReportMode.IMMEDIATE) {
                if (parm.getDate() == null) {
                    throw new SchedulerContextException(parm.getName() + "Date", DefaultSchedulerService.PROVIDE_A_VALUE_TEXT);
                }
            } else {
                if (parm.getInterval() == null || !ReportParameterBuilder.Intervals.ALL.contains(parm.getInterval())) {
                    throw new SchedulerContextException(parm.getName() + "Interval", "The provided value must be any of the following {0}", ReportParameterBuilder.Intervals.ALL);
                }
                if (parm.getCount() == null) {
                    throw new SchedulerContextException(parm.getName() + "Count", DefaultSchedulerService.PROVIDED_VALUE_GREATER_ZERO_TEXT);
                }
            }
            if (parm.getHours() == null) {
                throw new SchedulerContextException(parm.getName() + "Hours", DefaultSchedulerService.PROVIDE_A_VALUE_TEXT);
            }
            if (parm.getHours() < 0 || parm.getHours() > 23) {
                throw new SchedulerContextException(parm.getName() + "Hours", "Please provide a value between 0 and 23");
            }
            if (parm.getMinutes() == null) {
                throw new SchedulerContextException(parm.getName() + "Minutes", DefaultSchedulerService.PROVIDE_A_VALUE_TEXT);
            }
            if (parm.getMinutes() < 0 || parm.getMinutes() > 59) {
                throw new SchedulerContextException(parm.getName() + "Minutes", "Please provide a value between 0 and 59");
            }
        }
    }
}

