/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.webuiColors.CategoryColors;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.web.category.Category;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class CategoryUtil {
    public static final DecimalFormat valueFormat = new DecimalFormat("0.000");

    private CategoryUtil() {
    }

    public static String formatValue(double value) {
        return valueFormat.format(value);
    }

    public static String getCategoryColor(Category category) throws IOException, MarshalException, ValidationException {
        if (category == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return CategoryUtil.getCategoryColor(category.getNormalThreshold(), category.getWarningThreshold(), category.getValue());
    }

    public static String getCategoryClass(Category category) throws IOException, MarshalException, ValidationException {
        if (category == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return CategoryUtil.getCategoryClass(category.getNormalThreshold(), category.getWarningThreshold(), category.getValue());
    }

    public static String getCategoryColor(Category category, double value) throws IOException, MarshalException, ValidationException {
        if (category == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return CategoryUtil.getCategoryColor(category.getNormalThreshold(), category.getWarningThreshold(), value);
    }

    public static String getCategoryClass(Category category, double value) throws IOException, MarshalException, ValidationException {
        if (category == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return CategoryUtil.getCategoryClass(category.getNormalThreshold(), category.getWarningThreshold(), value);
    }

    public static String getCategoryColor(double normal, double warning, double value) throws IOException, MarshalException, ValidationException {
        String m_green = null;
        String m_yellow = null;
        String m_red = null;
        CategoryColors m_colorsconfig = new CategoryColors();
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.WEBUI_COLORS_FILE_NAME);
        m_colorsconfig = (CategoryColors)CastorUtils.unmarshal(CategoryColors.class, (Resource)new FileSystemResource(cfgFile));
        m_green = m_colorsconfig.getGreen();
        m_yellow = m_colorsconfig.getYellow();
        String color = m_red = m_colorsconfig.getRed();
        if (value >= normal) {
            color = m_green;
        } else if (value >= warning) {
            color = m_yellow;
        }
        return color;
    }

    public static String getCategoryClass(double normal, double warning, double value) {
        String m_crit;
        String m_good = "Normal";
        String m_warn = "Warning";
        String _class = m_crit = "Critical";
        if (value >= normal) {
            _class = m_good;
        } else if (value >= warning) {
            _class = m_warn;
        }
        return _class;
    }
}

