/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.api;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.opennms.core.resource.Vault;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.utils.TcpEventProxy;
import org.opennms.web.WebSecurityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Util {
    protected static final char[] substKeywords = new char[]{'s', 'h', 'p', 'x', 'c'};
    protected static final String[] hostHeaders = new String[]{"X-Forwarded-Host", "X-Host", "Host"};

    public static String calculateUrlBase(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String tmpl = Vault.getProperty((String)"opennms.web.base-url");
        if (tmpl == null) {
            tmpl = "%s://%x%c/";
        }
        return Util.substituteUrl(request, tmpl);
    }

    protected static String substituteUrl(HttpServletRequest request, String tmpl) {
        String[] replacements = new String[]{request.getScheme(), request.getServerName(), Integer.toString(request.getServerPort()), Util.getHostHeader(request), request.getContextPath()};
        StringBuffer out = new StringBuffer(48);
        int i = 0;
        block0: while (i < tmpl.length()) {
            char c;
            if ((c = tmpl.charAt(i++)) == '%' && i < tmpl.length()) {
                char d = tmpl.charAt(i++);
                for (int key = 0; key < substKeywords.length; ++key) {
                    if (d != substKeywords[key]) continue;
                    out.append(replacements[key]);
                    continue block0;
                }
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String getHostHeader(HttpServletRequest request) {
        for (int i = 0; i < hostHeaders.length; ++i) {
            String ret = request.getHeader(hostHeaders[i]);
            if (ret == null) continue;
            return ret;
        }
        return request.getServerName() + ":" + Integer.toString(request.getServerPort());
    }

    public static String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public static String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public static String makeHiddenTags(HttpServletRequest request) {
        return Util.makeHiddenTags(request, new HashMap(), new String[0]);
    }

    public static String makeHiddenTags(HttpServletRequest request, Map additions) {
        return Util.makeHiddenTags(request, additions, new String[0]);
    }

    public static String makeHiddenTags(HttpServletRequest request, String[] ignores) {
        return Util.makeHiddenTags(request, new HashMap(), ignores);
    }

    public static String makeHiddenTags(HttpServletRequest request, Map additions, String[] ignores) {
        return Util.makeHiddenTags(request, additions, ignores, IgnoreType.BOTH);
    }

    public static String makeHiddenTags(HttpServletRequest request, Map additions, String[] ignores, IgnoreType ignoreType) {
        if (request == null || additions == null || ignores == null || ignoreType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> ignoreList = new ArrayList<String>();
        for (int i = 0; i < ignores.length; ++i) {
            ignoreList.add(ignores[i]);
        }
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String[] values = request.getParameterValues(name);
            if (ignoreType != IgnoreType.ADDITIONS_ONLY && ignoreList.contains(name) || values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                buffer.append("<input type=\"hidden\" name=\"");
                buffer.append(name);
                buffer.append("\" value=\"");
                buffer.append(WebSecurityUtils.sanitizeString(values[i]));
                buffer.append("\" />");
                buffer.append("\n");
            }
        }
        Set keySet = additions.keySet();
        for (String name : keySet) {
            String[] stringArray;
            Object tmp = additions.get(name);
            if (tmp instanceof String[]) {
                stringArray = (String[])tmp;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)tmp;
            }
            String[] values = stringArray;
            if (ignoreType != IgnoreType.REQUEST_ONLY && ignoreList.contains(name) || values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                buffer.append("<input type=\"hidden\" name=\"");
                buffer.append(name);
                buffer.append("\" value=\"");
                buffer.append(values[i]);
                buffer.append("\" />");
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    public static String makeQueryString(HttpServletRequest request) {
        return Util.makeQueryString(request, new HashMap(), new String[0]);
    }

    public static String makeQueryString(HttpServletRequest request, Map additions) {
        return Util.makeQueryString(request, additions, new String[0]);
    }

    public static String makeQueryString(HttpServletRequest request, String[] ignores) {
        return Util.makeQueryString(request, new HashMap(), ignores);
    }

    public static String makeQueryString(HttpServletRequest request, Map additions, String[] ignores) {
        return Util.makeQueryString(request, additions, ignores, IgnoreType.BOTH);
    }

    public static String makeQueryString(HttpServletRequest request, Map additions, String[] ignores, IgnoreType ignoreType) {
        if (request == null || additions == null || ignores == null || ignoreType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> ignoreList = new ArrayList<String>();
        for (int i = 0; i < ignores.length; ++i) {
            ignoreList.add(ignores[i]);
        }
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String[] values = request.getParameterValues(name);
            if (ignoreType != IgnoreType.ADDITIONS_ONLY && ignoreList.contains(name) || values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                buffer.append("&");
                buffer.append(name);
                buffer.append("=");
                buffer.append(Util.encode(values[i]));
            }
        }
        Set keySet = additions.keySet();
        for (String name : keySet) {
            String[] values;
            Object tmp = additions.get(name);
            if (tmp instanceof String[]) {
                values = (String[])tmp;
            } else if (tmp instanceof String) {
                values = new String[]{(String)tmp};
            } else {
                throw new IllegalArgumentException("addition \"" + name + "\" is not of type String or String[], but is of type: " + tmp.getClass().getName());
            }
            if (ignoreType != IgnoreType.REQUEST_ONLY && ignoreList.contains(name) || values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                buffer.append("&");
                buffer.append(name);
                buffer.append("=");
                buffer.append(Util.encode(values[i]));
            }
        }
        if (buffer.length() > 0 && buffer.charAt(0) == '&') {
            buffer.deleteCharAt(0);
        }
        return buffer.toString();
    }

    public static Map<String, String> getOrderedMap(String[][] names) {
        TreeMap<String, String> orderedMap = new TreeMap<String, String>();
        for (int i = 0; i < names.length; ++i) {
            orderedMap.put(names[i][1], names[i][0]);
        }
        return orderedMap;
    }

    public static String htmlify(String input) {
        return input == null ? null : input.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static EventProxy createEventProxy() {
        String proxyHostName = Vault.getProperty((String)"opennms.rtc.event.proxy.host") == null ? "127.0.0.1" : Vault.getProperty((String)"opennms.rtc.event.proxy.host");
        String proxyHostPort = Vault.getProperty((String)"opennms.rtc.event.proxy.port") == null ? Integer.toString(5817) : Vault.getProperty((String)"opennms.rtc.event.proxy.port");
        String proxyHostTimeout = Vault.getProperty((String)"opennms.rtc.event.proxy.timeout") == null ? Integer.toString(2000) : Vault.getProperty((String)"opennms.rtc.event.proxy.timeout");
        InetAddress proxyAddr = null;
        TcpEventProxy proxy = null;
        try {
            proxyAddr = InetAddress.getByName(proxyHostName);
        }
        catch (UnknownHostException e) {
            proxyAddr = null;
        }
        if (proxyAddr == null) {
            try {
                proxy = new TcpEventProxy();
            }
            catch (UnknownHostException e) {
                throw new UndeclaredThrowableException(e);
            }
        } else {
            proxy = new TcpEventProxy(new InetSocketAddress(proxyAddr, Integer.parseInt(proxyHostPort)), Integer.parseInt(proxyHostTimeout));
        }
        return proxy;
    }

    public static final String formatDateToUIString(Date date) {
        return DateFormat.getDateTimeInstance(3, 2).format(date);
    }

    public static String convertToJsSafeString(String str) {
        String retStr = str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "\\t").replace("\r", "\\r").replace("\n", "\\n").replace("\b", "\\b");
        return retStr;
    }

    public static class IgnoreType {
        public static final int _REQUEST_ONLY = 0;
        public static final int _ADDITIONS_ONLY = 0;
        public static final int _BOTH = 0;
        public static final IgnoreType REQUEST_ONLY = new IgnoreType(0);
        public static final IgnoreType ADDITIONS_ONLY = new IgnoreType(0);
        public static final IgnoreType BOTH = new IgnoreType(0);
        protected int value;

        private IgnoreType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

