/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.servlet;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.opennms.core.utils.WebSecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(XssRequestWrapper.class);
    private Map<String, String[]> sanitized_parameters;
    private Map<String, String[]> original_parameters;

    public XssRequestWrapper(HttpServletRequest req) {
        super(req);
        this.original_parameters = req.getParameterMap();
        this.sanitized_parameters = this.getParameterMap();
        this.snzLogger();
    }

    public String getParameter(String name) {
        String[] vals = this.getParameterMap().get(name);
        if (vals != null && vals.length > 0) {
            return vals[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        if (this.sanitized_parameters == null) {
            this.sanitized_parameters = this.sanitizeParamMap(this.original_parameters);
        }
        return this.sanitized_parameters;
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public void removeAttribute(String name) {
        super.getRequest().removeAttribute(name);
    }

    public void setAttribute(String name, Object o) {
        super.getRequest().setAttribute(name, o);
    }

    public Object getAttribute(String name) {
        return super.getRequest().getAttribute(name);
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        super.getRequest().setCharacterEncoding(enc);
    }

    public String getCharacterEncoding() {
        return super.getRequest().getCharacterEncoding();
    }

    private Map<String, String[]> sanitizeParamMap(Map<String, String[]> raw) {
        HashMap<String, String[]> res = new HashMap<String, String[]>();
        if (raw == null) {
            return res;
        }
        for (Map.Entry<String, String[]> entry : raw.entrySet()) {
            String key = entry.getKey();
            String[] rawVals = entry.getValue();
            String[] snzVals = new String[rawVals.length];
            for (int i = 0; i < rawVals.length; ++i) {
                snzVals[i] = WebSecurityUtils.sanitizeString((String)rawVals[i]);
            }
            res.put(key, snzVals);
        }
        return res;
    }

    private void snzLogger() {
        for (Map.Entry<String, String[]> entry : this.original_parameters.entrySet()) {
            String key = entry.getKey();
            String[] rawVals = entry.getValue();
            String[] snzVals = this.sanitized_parameters.get(key);
            if (rawVals == null || rawVals.length <= 0) continue;
            for (int i = 0; i < rawVals.length; ++i) {
                if (rawVals[i].equals(snzVals[i])) {
                    LOG.debug("Sanitization. Param seems safe: {}[{}]={}", new Object[]{key, i, snzVals[i]});
                    continue;
                }
                LOG.debug("Sanitization. Param modified: {}[{}]={}", new Object[]{key, i, snzVals[i]});
            }
        }
    }
}

