/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyCheckingContextListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(DependencyCheckingContextListener.class);
    private static final String IGNORE_ERRORS_PROPERTY = "dontBlameOpenNMS";
    private static final String IGNORE_ERRORS_MESSAGE = "but don't blame OpenNMS for any errors that occur without switching back to a supported JVM and setting the property back to 'false', first.";

    public void contextDestroyed(ServletContextEvent event) {
    }

    public void contextInitialized(ServletContextEvent event) {
        Boolean skipJvm = Boolean.valueOf(System.getProperty("opennms.skipjvmcheck"));
        if (!skipJvm.booleanValue()) {
            this.checkJvmName(event.getServletContext());
        }
    }

    private void checkJvmName(ServletContext context) {
        String systemProperty = "java.vm.name";
        String[] acceptableProperties = new String[]{"HotSpot(TM)", "BEA JRockit", "OpenJDK"};
        String vmName = System.getProperty("java.vm.name");
        if (vmName == null) {
            this.logAndOrDie(context, "System property 'java.vm.name' is not set so we can't figure out if this version of Java is supported");
        }
        boolean ok = false;
        for (String systemPropertyMatch : acceptableProperties) {
            if (!vmName.contains(systemPropertyMatch)) continue;
            ok = true;
        }
        if (ok) {
            LOG.info("System property '{}' appears to contain a suitable JVM signature ('{}') -- congratulations!  ;)", (Object)"java.vm.name", (Object)vmName);
        } else {
            this.logAndOrDie(context, "System property 'java.vm.name' does not contain a suitable JVM signature ('" + vmName + "').  OpenNMS recommends the official Sun JVM.");
        }
    }

    private void logAndOrDie(ServletContext context, String message) {
        String webXmlPath = context.getRealPath("/WEB-INF/web.xml");
        if (!Boolean.parseBoolean(context.getInitParameter(IGNORE_ERRORS_PROPERTY))) {
            String howToFixMessage = "You can edit " + webXmlPath + " and change the value for the '" + IGNORE_ERRORS_PROPERTY + "' context parameter from 'false' to 'true', " + IGNORE_ERRORS_MESSAGE;
            LOG.error(message);
            LOG.error(howToFixMessage);
            throw new RuntimeException(message + "  " + howToFixMessage);
        }
        LOG.warn(message);
        LOG.warn("Context parameter '{}' is set in {}, so the above warning is not fatal,  {}", new Object[]{IGNORE_ERRORS_PROPERTY, webXmlPath, IGNORE_ERRORS_MESSAGE});
    }
}

