/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.io.IOException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.ViewsDisplayFactory;
import org.opennms.netmgt.config.viewsdisplay.Section;
import org.opennms.netmgt.config.viewsdisplay.View;
import org.opennms.web.category.Category;
import org.opennms.web.category.CategoryModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryList {
    private static final Logger LOG = LoggerFactory.getLogger(CategoryList.class);
    protected CategoryModel m_model;
    protected Section[] m_sections;
    private int m_disconnectTimeout;

    public CategoryList() throws ServletException {
        try {
            this.m_model = CategoryModel.getInstance();
        }
        catch (Throwable e) {
            LOG.error("failed to instantiate the category model: {}", (Object)e, (Object)e);
            throw new ServletException("failed to instantiate the category model: " + e, e);
        }
        try {
            ViewsDisplayFactory.init();
            ViewsDisplayFactory viewsDisplayFactory = ViewsDisplayFactory.getInstance();
            View view = viewsDisplayFactory.getDefaultView();
            if (view != null) {
                this.m_sections = view.getSection();
                this.m_disconnectTimeout = viewsDisplayFactory.getDisconnectTimeout();
                LOG.debug("found display rules from viewsdisplay.xml");
            } else {
                LOG.debug("did not find display rules from viewsdisplay.xml");
            }
        }
        catch (Throwable e) {
            LOG.error("Couldn't open viewsdisplay factory on categories box: {}", (Object)e, (Object)e);
        }
    }

    public List<Section> getSections(Map<String, Category> categoryMap) throws IOException {
        if (this.m_sections != null) {
            return Arrays.asList(this.m_sections);
        }
        ArrayList<Section> sectionList = null;
        Section section = new Section();
        section.setSectionName("Category");
        TreeMap<String, Category> orderedMap = new TreeMap<String, Category>(categoryMap);
        for (Map.Entry<String, Category> entry : orderedMap.entrySet()) {
            Category category = entry.getValue();
            section.addCategory(category.getName());
        }
        sectionList = new ArrayList<Section>();
        sectionList.add(section);
        return sectionList;
    }

    public Map<String, List<Category>> getCategoryData() throws IOException, MarshalException, ValidationException {
        Map<String, Category> categoryMap = this.m_model.getCategoryMap();
        List<Section> sectionList = this.getSections(categoryMap);
        LinkedHashMap categoryData = new LinkedHashMap();
        for (Section section : sectionList) {
            LinkedList<Category> categories = new LinkedList<Category>();
            String[] categoryNames = section.getCategory();
            for (int j = 0; j < categoryNames.length; ++j) {
                String categoryName = categoryNames[j];
                Category category = categoryMap.get(categoryName);
                if (category == null) {
                    categories.add(new Category(categoryName));
                    continue;
                }
                categories.add(category);
            }
            categoryData.put(section.getSectionName(), categories);
        }
        return Collections.unmodifiableMap(categoryData);
    }

    public long getEarliestUpdate(Map<String, List<Category>> categoryData) {
        long earliestUpdate = 0L;
        for (Map.Entry<String, List<Category>> entry : categoryData.entrySet()) {
            List<Category> categories = entry.getValue();
            for (Category category : categories) {
                if (category.getLastUpdated() == null) {
                    return -1L;
                }
                if (earliestUpdate != 0L && earliestUpdate <= category.getLastUpdated().getTime()) continue;
                earliestUpdate = category.getLastUpdated().getTime();
            }
        }
        return earliestUpdate;
    }

    public boolean isDisconnected() throws IOException, MarshalException, ValidationException {
        return this.isDisconnected(this.getEarliestUpdate(this.getCategoryData()));
    }

    public boolean isDisconnected(long earliestUpdate) {
        return earliestUpdate < 1L || earliestUpdate + (long)this.m_disconnectTimeout < System.currentTimeMillis();
    }

    private void printBox(Writer out, HttpServletResponse response) throws IOException, MarshalException, ValidationException {
        Map<String, List<Category>> categoryData = this.getCategoryData();
        out.write("<table width=\"100%\" border=\"1\" cellspacing=\"0\" cellpadding=\"2\" bordercolor=\"black\" bgcolor=\"#cccccc\">\n");
        long earliestUpdate = this.getEarliestUpdate(categoryData);
        boolean opennmsDisconnect = this.isDisconnected(earliestUpdate);
        for (Map.Entry<String, List<Category>> entry : categoryData.entrySet()) {
            String sectionName = entry.getKey();
            out.write("<tr bgcolor=\"#999999\">\n");
            out.write("<td width=\"50%\"><b>" + sectionName + "</b></td>\n");
            out.write("<td width=\"20%\" align=\"right\"><b>Outages</b></td>\n");
            out.write("<td width=\"30%\" align=\"right\"><b>24hr Avail</b></td>\n");
            out.write("</tr>\n");
            List<Category> categories = entry.getValue();
            for (Category category : categories) {
                String categoryName = category.getName();
                String title = category.getTitle();
                String outageColor = opennmsDisconnect ? "lightblue" : category.getOutageColor();
                String availColor = opennmsDisconnect ? "lightblue" : category.getAvailColor();
                String lastUpdated = category.getLastUpdated() == null ? "Never" : category.getLastUpdated().toString();
                long lastUpdatedTime = category.getLastUpdated() == null ? -1L : category.getLastUpdated().getTime();
                String outageText = category.getOutageText();
                String availText = "<b>" + category.getAvailText() + "</b>";
                out.write("<tr>\n");
                out.write("<td><a href=\"rtc/category.jsp?category=" + URLEncoder.encode(response.encodeURL(categoryName), "UTF-8") + "\" title=\"" + title + "\">" + categoryName + "</a></td>\n");
                out.write("<td bgcolor=\"" + outageColor + "\" align=\"right\" title=\"Updated: " + lastUpdated + "\">" + outageText + "</td>\n");
                out.write("<td bgcolor=\"" + availColor + "\" align=\"right\" title=\"Updated: " + lastUpdated + "\">" + availText + "</td>\n");
                out.write("<!-- Last updated " + lastUpdated + " -->\n");
                out.write("<!-- Epoch time:  " + lastUpdatedTime + " -->\n");
                out.write("</tr>\n");
            }
        }
        out.write("<tr bgcolor=\"#999999\">\n");
        if (opennmsDisconnect) {
            out.write("<td colspan=\"3\"><font color=\"#bb1111\">OpenNMS Disconnect -- is the OpenNMS daemon running?<br/>Last update: " + (earliestUpdate > 0L ? new Date(earliestUpdate).toString() : "one or more categories have never been updated.") + "</font></td>\n");
        } else {
            out.write("<td colspan=\"3\">Percentage over last 24 hours</td>\n");
        }
        out.write("</tr>\n");
        out.write("</table>\n");
    }
}

