/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.CategoryFactory;
import org.opennms.netmgt.config.categories.CatFactory;
import org.opennms.web.category.Category;

public class CategoryModel {
    public static final String OVERALL_AVAILABILITY_CATEGORY = "Overall Service Availability";
    private static CategoryModel m_instance;
    private HashMap<String, Category> m_categoryMap = new HashMap();
    private CatFactory m_factory = null;
    private ThreadCategory m_log = ThreadCategory.getInstance((String)"RTC");

    public static synchronized CategoryModel getInstance() throws IOException, MarshalException, ValidationException {
        if (m_instance == null) {
            m_instance = new CategoryModel();
        }
        return m_instance;
    }

    private CategoryModel() throws IOException, MarshalException, ValidationException {
        CategoryFactory.init();
        this.m_factory = CategoryFactory.getInstance();
        this.m_log.debug("The CategoryModel object was created");
    }

    public Category getCategory(String categoryName) {
        if (categoryName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return this.m_categoryMap.get(categoryName);
    }

    public Map<String, Category> getCategoryMap() {
        return Collections.unmodifiableMap(new HashMap<String, Category>(this.m_categoryMap));
    }

    public double getCategoryNormalThreshold(String categoryName) {
        if (categoryName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return this.m_factory.getNormal(categoryName);
    }

    public double getCategoryWarningThreshold(String categoryName) {
        if (categoryName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return this.m_factory.getWarning(categoryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCategoryComment(String categoryName) {
        if (categoryName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String comment = null;
        this.m_factory.getReadLock().lock();
        try {
            org.opennms.netmgt.config.categories.Category category = this.m_factory.getCategory(categoryName);
            if (category != null) {
                comment = category.getComment();
            }
        }
        finally {
            this.m_factory.getReadLock().unlock();
        }
        return comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCategory(org.opennms.netmgt.xml.rtc.Category rtcCategory) {
        if (rtcCategory == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String categoryName = rtcCategory.getCatlabel();
        this.m_factory.getWriteLock().lock();
        try {
            org.opennms.netmgt.config.categories.Category categoryDef = this.m_factory.getCategory(categoryName);
            Category category = new Category(categoryDef, rtcCategory, new Date());
            HashMap<String, Category> hashMap = this.m_categoryMap;
            synchronized (hashMap) {
                this.m_categoryMap.put(categoryName, category);
            }
        }
        finally {
            this.m_factory.getWriteLock().unlock();
        }
        this.m_log.debug(categoryName + " was updated");
    }

    public double getNodeAvailability(int nodeId) throws SQLException {
        GregorianCalendar cal = new GregorianCalendar();
        Date now = cal.getTime();
        ((Calendar)cal).add(5, -1);
        Date yesterday = cal.getTime();
        return this.getNodeAvailability(nodeId, yesterday, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getNodeAvailability(int nodeId, Date start, Date end) throws SQLException {
        if (start == null || end == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (end.before(start)) {
            throw new IllegalArgumentException("Cannot have an end time before the start time.");
        }
        if (end.equals(start)) {
            throw new IllegalArgumentException("Cannot have an end time equal to the start time.");
        }
        double avail = -1.0;
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("select getManagePercentAvailNodeWindow(?, ?, ?) as avail");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            stmt.setTimestamp(2, new Timestamp(end.getTime()));
            stmt.setTimestamp(3, new Timestamp(start.getTime()));
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                avail = rs.getDouble("avail");
            }
        }
        catch (SQLException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Failed to get node availability for nodeId %d", (Object[])new Object[]{nodeId});
        }
        finally {
            d.cleanUp();
        }
        return avail;
    }

    public Map<Integer, Double> getNodeAvailability(Set<Integer> nodeIds) throws SQLException {
        GregorianCalendar cal = new GregorianCalendar();
        Date now = cal.getTime();
        ((Calendar)cal).add(5, -1);
        Date yesterday = cal.getTime();
        return this.getNodeAvailability(nodeIds, yesterday, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Double> getNodeAvailability(Set<Integer> nodeIds, Date start, Date end) throws SQLException {
        if (nodeIds == null || nodeIds.size() == 0) {
            throw new IllegalArgumentException("Cannot take nodeIds null or with length 0.");
        }
        if (start == null || end == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (end.before(start)) {
            throw new IllegalArgumentException("Cannot have an end time before the start time.");
        }
        if (end.equals(start)) {
            throw new IllegalArgumentException("Cannot have an end time equal to the start time.");
        }
        double avail = -1.0;
        int nodeid = 0;
        TreeMap<Integer, Double> retMap = new TreeMap<Integer, Double>();
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            StringBuffer sb = new StringBuffer("select nodeid, getManagePercentAvailNodeWindow(nodeid, ?, ?)  from node where nodeid in (");
            Iterator<Integer> it = nodeIds.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
            PreparedStatement stmt = conn.prepareStatement(sb.toString());
            d.watch((Object)stmt);
            stmt.setTimestamp(1, new Timestamp(end.getTime()));
            stmt.setTimestamp(2, new Timestamp(start.getTime()));
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                nodeid = rs.getInt(1);
                avail = rs.getDouble(2);
                retMap.put(nodeid, avail);
            }
        }
        catch (SQLException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Failed to get node availability for nodeIds %s", (Object[])new Object[]{nodeIds});
        }
        finally {
            d.cleanUp();
        }
        return Collections.unmodifiableMap(retMap);
    }

    public double getInterfaceAvailability(int nodeId, String ipAddr) throws SQLException {
        if (ipAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        GregorianCalendar cal = new GregorianCalendar();
        Date now = cal.getTime();
        ((Calendar)cal).add(5, -1);
        Date yesterday = cal.getTime();
        return this.getInterfaceAvailability(nodeId, ipAddr, yesterday, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getInterfaceAvailability(int nodeId, String ipAddr, Date start, Date end) throws SQLException {
        if (ipAddr == null || start == null || end == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (end.before(start)) {
            throw new IllegalArgumentException("Cannot have an end time before the start time.");
        }
        if (end.equals(start)) {
            throw new IllegalArgumentException("Cannot have an end time equal to the start time.");
        }
        double avail = -1.0;
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("select getManagePercentAvailIntfWindow(?, ?, ?, ?) as avail");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.setTimestamp(3, new Timestamp(end.getTime()));
            stmt.setTimestamp(4, new Timestamp(start.getTime()));
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                avail = rs.getDouble("avail");
            }
        }
        catch (SQLException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Failed to get interface availability for nodeId %d, interface %s", (Object[])new Object[]{nodeId, ipAddr});
        }
        finally {
            d.cleanUp();
        }
        return avail;
    }

    public double getServiceAvailability(int nodeId, String ipAddr, int serviceId) throws SQLException {
        if (ipAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        GregorianCalendar cal = new GregorianCalendar();
        Date now = cal.getTime();
        ((Calendar)cal).add(5, -1);
        Date yesterday = cal.getTime();
        return this.getServiceAvailability(nodeId, ipAddr, serviceId, yesterday, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getServiceAvailability(int nodeId, String ipAddr, int serviceId, Date start, Date end) throws SQLException {
        if (ipAddr == null || start == null || end == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (end.before(start)) {
            throw new IllegalArgumentException("Cannot have an end time before the start time.");
        }
        if (end.equals(start)) {
            throw new IllegalArgumentException("Cannot have an end time equal to the start time.");
        }
        double avail = -1.0;
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("select getPercentAvailabilityInWindow(?, ?, ?, ?, ?) as avail from ifservices, ipinterface where ifservices.ipaddr = ipinterface.ipaddr and ifservices.nodeid = ipinterface.nodeid and ipinterface.ismanaged='M' and ifservices.nodeid=? and ifservices.ipaddr=? and serviceid=?");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.setInt(3, serviceId);
            stmt.setTimestamp(4, new Timestamp(end.getTime()));
            stmt.setTimestamp(5, new Timestamp(start.getTime()));
            stmt.setInt(6, nodeId);
            stmt.setString(7, ipAddr);
            stmt.setInt(8, serviceId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                avail = rs.getDouble("avail");
            }
        }
        catch (SQLException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Failed to get service availability for nodeId %d, interface %s, serviceId %d", (Object[])new Object[]{nodeId, ipAddr, serviceId});
        }
        finally {
            d.cleanUp();
        }
        return avail;
    }
}

