/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.ViewsDisplayFactory;
import org.opennms.netmgt.config.viewsdisplay.Section;
import org.opennms.netmgt.config.viewsdisplay.View;
import org.opennms.web.category.Category;
import org.opennms.web.category.CategoryModel;

public class CategoryList {
    protected CategoryModel m_model;
    protected Section[] m_sections;
    private int m_disconnectTimeout;

    public CategoryList() throws ServletException {
        try {
            this.m_model = CategoryModel.getInstance();
        }
        catch (Throwable e) {
            this.log().error("failed to instantiate the category model: " + e, e);
            throw new ServletException("failed to instantiate the category model: " + e, e);
        }
        try {
            ViewsDisplayFactory.init();
            ViewsDisplayFactory viewsDisplayFactory = ViewsDisplayFactory.getInstance();
            View view = viewsDisplayFactory.getDefaultView();
            if (view != null) {
                this.m_sections = view.getSection();
                this.m_disconnectTimeout = viewsDisplayFactory.getDisconnectTimeout();
                this.log().debug("found display rules from viewsdisplay.xml");
            } else {
                this.log().debug("did not find display rules from viewsdisplay.xml");
            }
        }
        catch (Throwable e) {
            this.log().error("Couldn't open viewsdisplay factory on categories box: " + e, e);
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public List<Section> getSections(Map<String, Category> categoryMap) throws IOException {
        if (this.m_sections != null) {
            return Arrays.asList(this.m_sections);
        }
        ArrayList<Section> sectionList = null;
        Section section = new Section();
        section.setSectionName("Category");
        TreeMap<String, Category> orderedMap = new TreeMap<String, Category>(categoryMap);
        for (Map.Entry<String, Category> entry : orderedMap.entrySet()) {
            Category category = entry.getValue();
            section.addCategory(category.getName());
        }
        sectionList = new ArrayList<Section>();
        sectionList.add(section);
        return sectionList;
    }

    public Map<String, List<Category>> getCategoryData() throws IOException, MarshalException, ValidationException {
        Map<String, Category> categoryMap = this.m_model.getCategoryMap();
        List<Section> sectionList = this.getSections(categoryMap);
        LinkedHashMap<String, List<Category>> categoryData = new LinkedHashMap<String, List<Category>>();
        for (Section section : sectionList) {
            LinkedList<Category> categories = new LinkedList<Category>();
            String[] categoryNames = section.getCategory();
            for (int j = 0; j < categoryNames.length; ++j) {
                String categoryName = categoryNames[j];
                Category category = categoryMap.get(categoryName);
                if (category == null) {
                    categories.add(new Category(categoryName));
                    continue;
                }
                categories.add(category);
            }
            categoryData.put(section.getSectionName(), categories);
        }
        return categoryData;
    }

    public long getEarliestUpdate(Map<String, List<Category>> categoryData) {
        long earliestUpdate = 0L;
        for (String sectionName : categoryData.keySet()) {
            List<Category> categories = categoryData.get(sectionName);
            for (Category category : categories) {
                if (category.getLastUpdated() == null) {
                    return -1L;
                }
                if (earliestUpdate != 0L && earliestUpdate <= category.getLastUpdated().getTime()) continue;
                earliestUpdate = category.getLastUpdated().getTime();
            }
        }
        return earliestUpdate;
    }

    public boolean isDisconnected() throws IOException, MarshalException, ValidationException {
        return this.isDisconnected(this.getEarliestUpdate(this.getCategoryData()));
    }

    public boolean isDisconnected(long earliestUpdate) {
        return earliestUpdate < 1L || earliestUpdate + (long)this.m_disconnectTimeout < System.currentTimeMillis();
    }

    private void printBox(JspWriter out, HttpServletResponse response) throws IOException, MarshalException, ValidationException {
        Map<String, List<Category>> categoryData = this.getCategoryData();
        out.println("<table width=\"100%\" border=\"1\" cellspacing=\"0\" cellpadding=\"2\" bordercolor=\"black\" bgcolor=\"#cccccc\">");
        long earliestUpdate = this.getEarliestUpdate(categoryData);
        boolean opennmsDisconnect = this.isDisconnected(earliestUpdate);
        for (String sectionName : categoryData.keySet()) {
            out.println("<tr bgcolor=\"#999999\">");
            out.println("<td width=\"50%\"><b>" + sectionName + "</b></td>");
            out.println("<td width=\"20%\" align=\"right\"><b>Outages</b></td>");
            out.println("<td width=\"30%\" align=\"right\"><b>24hr Avail</b></td>");
            out.println("</tr>");
            List<Category> categories = categoryData.get(sectionName);
            for (Category category : categories) {
                String categoryName = category.getName();
                String title = category.getTitle();
                String outageColor = opennmsDisconnect ? "lightblue" : category.getOutageColor();
                String availColor = opennmsDisconnect ? "lightblue" : category.getAvailColor();
                String lastUpdated = category.getLastUpdated() == null ? "Never" : category.getLastUpdated().toString();
                long lastUpdatedTime = category.getLastUpdated() == null ? -1L : category.getLastUpdated().getTime();
                String outageText = category.getOutageText();
                String availText = "<b>" + category.getAvailText() + "</b>";
                out.println("<tr>");
                out.println("<td><a href=\"rtc/category.jsp?category=" + URLEncoder.encode(response.encodeURL(categoryName), "UTF-8") + "\" title=\"" + title + "\">" + categoryName + "</a></td>");
                out.println("<td bgcolor=\"" + outageColor + "\" align=\"right\" title=\"Updated: " + lastUpdated + "\">" + outageText + "</td>");
                out.println("<td bgcolor=\"" + availColor + "\" align=\"right\" title=\"Updated: " + lastUpdated + "\">" + availText + "</td>");
                out.println("<!-- Last updated " + lastUpdated + " -->");
                out.println("<!-- Epoch time:  " + lastUpdatedTime + " -->");
                out.println("</tr>");
            }
        }
        out.println("<tr bgcolor=\"#999999\">");
        if (opennmsDisconnect) {
            out.println("<td colspan=\"3\"><font color=\"#bb1111\">OpenNMS Disconnect -- is the OpenNMS daemon running?<br/>Last update: " + (earliestUpdate > 0L ? new Date(earliestUpdate).toString() : "one or more categories have never been updated.") + "</font></td>");
        } else {
            out.println("<td colspan=\"3\">Percentage over last 24 hours</td>");
        }
        out.println("</tr>");
        out.println("</table>");
    }
}

